/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.conv;

import com.questdb.common.NumericException;
import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.Numbers;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormat;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocale;
import com.questdb.std.time.DateLocaleFactory;
import com.questdb.std.time.Dates;
import com.questdb.std.time.TimeZoneRules;

public class DateToCharTZLocaleFunction
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, env) -> new DateToCharTZLocaleFunction(position, env.dateFormatFactory, env.dateLocaleFactory);
    private final DateFormatFactory dateFormatFactory;
    private final DateLocaleFactory dateLocaleFactory;
    private final StringSink sinkA = new StringSink();
    private final StringSink sinkB = new StringSink();
    private DateLocale dateLocale;
    private DateFormat fmt;
    private VirtualColumn column;
    private long offset;
    private CharSequence tz;
    private VirtualColumn tzArg;
    private TimeZoneRules rules;

    private DateToCharTZLocaleFunction(int position, DateFormatFactory dateFormatFactory, DateLocaleFactory dateLocaleFactory) {
        super(7, position);
        this.dateFormatFactory = dateFormatFactory;
        this.dateLocaleFactory = dateLocaleFactory;
    }

    @Override
    public CharSequence getFlyweightStr(Record rec) {
        return this.getFlyweightStr0(rec, this.sinkA);
    }

    @Override
    public CharSequence getFlyweightStrB(Record rec) {
        return this.getFlyweightStr0(rec, this.sinkB);
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        long instant = this.column.getLong(rec);
        if (instant > Long.MIN_VALUE) {
            this.fmtToSink(instant, sink);
        }
    }

    @Override
    public boolean isConstant() {
        return this.column.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
        this.column.prepare(facade);
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        switch (pos) {
            case 0: {
                this.column = arg;
                break;
            }
            case 1: {
                this.fmt = this.dateFormatFactory.get(arg.getFlyweightStr(null));
                break;
            }
            case 2: {
                this.tz = arg.getFlyweightStr(null);
                this.tzArg = arg;
                break;
            }
            case 3: {
                this.dateLocale = this.dateLocaleFactory.getDateLocale(arg.getFlyweightStr(null));
                if (this.dateLocale == null) {
                    throw QueryError.$(arg.getPosition(), "Invalid locale");
                }
                long l = Dates.parseOffset(this.tz, 0, this.tz.length());
                try {
                    if (l == Long.MIN_VALUE) {
                        this.rules = this.dateLocale.getZoneRules(Numbers.decodeInt(this.dateLocale.matchZone(this.tz, 0, this.tz.length())));
                        break;
                    }
                    this.offset = (long)Numbers.decodeInt(l) * 60000L;
                    this.rules = null;
                    break;
                }
                catch (NumericException e) {
                    throw QueryError.$(this.tzArg.getPosition(), "Invalid timezone");
                }
            }
        }
    }

    private void fmtToSink(long instant, CharSink sink) {
        if (this.rules != null) {
            this.fmt.format(instant + this.rules.getOffset(instant), this.dateLocale, this.tz, sink);
        } else {
            this.fmt.format(instant + this.offset, this.dateLocale, this.tz, sink);
        }
    }

    private CharSequence getFlyweightStr0(Record rec, StringSink sink) {
        long instant = this.column.getLong(rec);
        if (instant == Long.MIN_VALUE) {
            return null;
        }
        sink.clear();
        this.fmtToSink(instant, sink);
        return sink;
    }
}

