/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.conv;

import com.questdb.common.NumericException;
import com.questdb.common.Record;
import com.questdb.ql.ops.AbstractUnaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.time.DateFormatUtils;

public class ToDateFunction
extends AbstractUnaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new ToDateFunction(position);

    private ToDateFunction(int position) {
        super(10, position);
    }

    @Override
    public long getDate(Record rec) {
        return this.getLong(rec);
    }

    @Override
    public double getDouble(Record rec) {
        return this.getLong(rec);
    }

    @Override
    public long getLong(Record rec) {
        try {
            CharSequence s = this.value.getFlyweightStr(rec);
            return s == null ? Long.MIN_VALUE : DateFormatUtils.parseDateTime(s);
        }
        catch (NumericException ignore) {
            return 0L;
        }
    }
}

