/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.conv;

import com.questdb.common.NumericException;
import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.time.DateFormat;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocale;
import com.questdb.std.time.DateLocaleFactory;

public class ToDateThreeArgFunction
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, env) -> new ToDateThreeArgFunction(position, env.dateFormatFactory, env.dateLocaleFactory);
    private final DateFormatFactory dateFormatFactory;
    private final DateLocaleFactory dateLocaleFactory;
    private DateFormat fmt;
    private VirtualColumn column;
    private DateLocale locale;

    private ToDateThreeArgFunction(int position, DateFormatFactory dateFormatFactory, DateLocaleFactory dateLocaleFactory) {
        super(10, position);
        this.dateFormatFactory = dateFormatFactory;
        this.dateLocaleFactory = dateLocaleFactory;
    }

    @Override
    public long getDate(Record rec) {
        return this.getLong(rec);
    }

    @Override
    public double getDouble(Record rec) {
        return this.getLong(rec);
    }

    @Override
    public long getLong(Record rec) {
        try {
            CharSequence s = this.column.getFlyweightStr(rec);
            return s == null ? Long.MIN_VALUE : this.fmt.parse(s, this.locale);
        }
        catch (NumericException ignore) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public boolean isConstant() {
        return this.column.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
        this.column.prepare(facade);
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        switch (pos) {
            case 0: {
                this.column = arg;
                break;
            }
            case 1: {
                this.fmt = this.dateFormatFactory.get(arg.getFlyweightStr(null));
                break;
            }
            case 2: {
                this.locale = this.dateLocaleFactory.getDateLocale(arg.getFlyweightStr(null));
                if (this.locale != null) break;
                throw QueryError.$(arg.getPosition(), "Invalid locale");
            }
        }
    }
}

