/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.conv;

import com.questdb.common.NumericException;
import com.questdb.common.Record;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.time.DateFormat;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocale;

public class ToDateTwoArgFunction
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, env) -> new ToDateTwoArgFunction(position, env.dateFormatFactory, env.dateLocaleFactory.getDefaultDateLocale());
    private final DateFormatFactory dateFormatFactory;
    private final DateLocale dateLocale;
    private DateFormat fmt;

    private ToDateTwoArgFunction(int position, DateFormatFactory dateFormatFactory, DateLocale defaultLocale) {
        super(10, position);
        this.dateFormatFactory = dateFormatFactory;
        this.dateLocale = defaultLocale;
    }

    @Override
    public long getDate(Record rec) {
        return this.getLong(rec);
    }

    @Override
    public double getDouble(Record rec) {
        return this.getLong(rec);
    }

    @Override
    public long getLong(Record rec) {
        try {
            CharSequence s = this.lhs.getFlyweightStr(rec);
            return s == null ? Long.MIN_VALUE : this.fmt.parse(s, this.dateLocale);
        }
        catch (NumericException ignore) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public void setRhs(VirtualColumn rhs) throws ParserException {
        super.setRhs(rhs);
        this.fmt = this.dateFormatFactory.get(rhs.getFlyweightStr(null));
    }
}

