/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.conv;

import com.questdb.common.ColumnType;
import com.questdb.common.Record;
import com.questdb.common.SymbolTable;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractUnaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;

public class TypeOfFunction
extends AbstractUnaryOperator
implements SymbolTable {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new TypeOfFunction(position);
    private int valueType;
    private String typeName;
    private int typeNameLen;

    private TypeOfFunction(int position) {
        super(8, position);
    }

    @Override
    public CharSequence getFlyweightStr(Record rec) {
        return this.typeName;
    }

    @Override
    public CharSequence getFlyweightStrB(Record rec) {
        return this.getFlyweightStr(rec);
    }

    @Override
    public int getInt(Record rec) {
        return this.valueType;
    }

    @Override
    public int getStrLen(Record rec) {
        return this.typeNameLen;
    }

    @Override
    public String getSym(Record rec) {
        return this.typeName;
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this;
    }

    @Override
    public int getQuick(CharSequence value) {
        return this.valueType;
    }

    @Override
    public int size() {
        return ColumnType.count();
    }

    @Override
    public String value(int key) {
        return this.typeName;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        super.setArg(pos, arg);
        this.valueType = this.value.getType();
        this.typeName = ColumnType.nameOf(this.valueType);
        this.typeNameLen = this.typeName.length();
    }
}

