/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.count;

import com.questdb.common.Record;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.ops.AbstractUnaryAggregator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumnFactory;

public final class CountFloatAggregator
extends AbstractUnaryAggregator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new CountFloatAggregator(position);

    private CountFloatAggregator(int position) {
        super(5, position);
    }

    @Override
    public void calculate(Record rec, DirectMapValues values) {
        float d = this.value.getFloat(rec);
        if (values.isNew()) {
            values.putLong(this.valueIndex, d != d ? 0L : 1L);
        } else if (d == d) {
            values.putLong(this.valueIndex, values.getLong(this.valueIndex) + 1L);
        }
    }
}

