/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.count;

import com.questdb.common.Record;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.ops.AbstractUnaryAggregator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumnFactory;

public final class CountLongAggregator
extends AbstractUnaryAggregator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new CountLongAggregator(position);

    private CountLongAggregator(int position) {
        super(5, position);
    }

    @Override
    public void calculate(Record rec, DirectMapValues values) {
        long d = this.value.getLong(rec);
        if (values.isNew()) {
            values.putLong(this.valueIndex, d == Long.MIN_VALUE ? 0L : 1L);
        } else if (d != Long.MIN_VALUE) {
            values.putLong(this.valueIndex, values.getLong(this.valueIndex) + 1L);
        }
    }
}

