/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.eq;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;

public class DoubleScaledEqualOperator
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new DoubleScaledEqualOperator(position);
    private VirtualColumn lhs;
    private VirtualColumn rhs;
    private VirtualColumn scale;

    private DoubleScaledEqualOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        double d = this.lhs.getDouble(rec) - this.rhs.getDouble(rec);
        return d > 0.0 ? d < this.scale.getDouble(rec) : d > -this.scale.getDouble(rec);
    }

    @Override
    public boolean isConstant() {
        return this.lhs.isConstant() && this.rhs.isConstant() && this.scale.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
        this.lhs.prepare(facade);
        this.rhs.prepare(facade);
        this.scale.prepare(facade);
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        switch (pos) {
            case 0: {
                this.lhs = arg;
                break;
            }
            case 1: {
                this.rhs = arg;
                break;
            }
            default: {
                this.scale = arg;
            }
        }
    }
}

