/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.eq;

import com.questdb.common.Record;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.IntervalCompiler;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.LongList;

public class StrEqualDateOperator
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new StrEqualDateOperator(position);
    private final LongList intervals = new LongList();
    private int intervalCount;

    private StrEqualDateOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        long date = this.rhs.getDate(rec);
        for (int i = 0; i < this.intervalCount; ++i) {
            if (date < IntervalCompiler.getIntervalLo(this.intervals, i)) {
                return false;
            }
            if (date > IntervalCompiler.getIntervalHi(this.intervals, i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setLhs(VirtualColumn lhs) throws ParserException {
        super.setLhs(lhs);
        CharSequence intervalStr = lhs.getFlyweightStr(null);
        if (intervalStr != null) {
            IntervalCompiler.parseIntervalEx(intervalStr, 0, intervalStr.length(), lhs.getPosition(), this.intervals);
        }
        this.intervalCount = this.intervals.size() / 2;
    }
}

