/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.minus;

import com.questdb.common.Record;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumnFactory;

public class MinusIntOperator
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new MinusIntOperator(position);

    private MinusIntOperator(int position) {
        super(4, position);
    }

    @Override
    public double getDouble(Record rec) {
        int l = this.lhs.getInt(rec);
        int r = this.rhs.getInt(rec);
        return l > Integer.MIN_VALUE && r > Integer.MIN_VALUE ? (double)(l - r) : Double.NaN;
    }

    @Override
    public float getFloat(Record rec) {
        int l = this.lhs.getInt(rec);
        int r = this.rhs.getInt(rec);
        return l > Integer.MIN_VALUE && r > Integer.MIN_VALUE ? (float)(l - r) : Float.NaN;
    }

    @Override
    public int getInt(Record rec) {
        int l = this.lhs.getInt(rec);
        int r = this.rhs.getInt(rec);
        return l > Integer.MIN_VALUE && r > Integer.MIN_VALUE ? l - r : Integer.MIN_VALUE;
    }

    @Override
    public long getLong(Record rec) {
        int l = this.lhs.getInt(rec);
        int r = this.rhs.getInt(rec);
        return l > Integer.MIN_VALUE && r > Integer.MIN_VALUE ? (long)(l - r) : Long.MIN_VALUE;
    }
}

