/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.neg;

import com.questdb.common.Record;
import com.questdb.ql.ops.AbstractUnaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumnFactory;

public class IntNegativeOperator
extends AbstractUnaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new IntNegativeOperator(position);

    private IntNegativeOperator(int position) {
        super(4, position);
    }

    @Override
    public double getDouble(Record rec) {
        int v = this.value.getInt(rec);
        return v == Integer.MIN_VALUE ? Double.NaN : (double)(-v);
    }

    @Override
    public int getInt(Record rec) {
        int v = this.value.getInt(rec);
        return v == Integer.MIN_VALUE ? Integer.MIN_VALUE : -v;
    }

    @Override
    public long getLong(Record rec) {
        int v = this.value.getInt(rec);
        return v == Integer.MIN_VALUE ? Long.MIN_VALUE : (long)(-v);
    }
}

