/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.neg;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;

public class LongNegativeOperator
extends AbstractVirtualColumn
implements Function {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new LongNegativeOperator(position);
    private VirtualColumn value;

    private LongNegativeOperator(int position) {
        super(5, position);
    }

    @Override
    public double getDouble(Record rec) {
        long l = this.value.getLong(rec);
        return l > Long.MIN_VALUE ? (double)(-l) : Double.NaN;
    }

    @Override
    public long getLong(Record rec) {
        long l = this.value.getLong(rec);
        return l > Long.MIN_VALUE ? -l : l;
    }

    @Override
    public boolean isConstant() {
        return this.value.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        this.value = arg;
    }
}

