/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.neq;

import com.questdb.common.Record;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.IntervalCompiler;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.LongList;

public class DateNotEqualStrConstOperator
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new DateNotEqualStrConstOperator(position);
    private final LongList intervals = new LongList();
    private int intervalCount;

    private DateNotEqualStrConstOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        long date = this.lhs.getDate(rec);
        if (date == Long.MIN_VALUE) {
            return false;
        }
        for (int i = 0; i < this.intervalCount; ++i) {
            if (date < IntervalCompiler.getIntervalLo(this.intervals, i)) {
                return true;
            }
            if (date > IntervalCompiler.getIntervalHi(this.intervals, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setRhs(VirtualColumn rhs) throws ParserException {
        super.setRhs(rhs);
        CharSequence intervalStr = rhs.getFlyweightStr(null);
        if (intervalStr != null) {
            IntervalCompiler.parseIntervalEx(intervalStr, 0, intervalStr.length(), rhs.getPosition(), this.intervals);
        }
        this.intervalCount = this.intervals.size() / 2;
    }
}

