/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.neq;

import com.questdb.common.Record;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.IntervalCompiler;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.LongList;

public class StrNotEqualDateOperator
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new StrNotEqualDateOperator(position);
    private final LongList intervals = new LongList();
    private int intervalCount;

    private StrNotEqualDateOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        long date = this.rhs.getDate(rec);
        for (int i = 0; i < this.intervalCount; ++i) {
            if (date < IntervalCompiler.getIntervalLo(this.intervals, i)) {
                return true;
            }
            if (date > IntervalCompiler.getIntervalHi(this.intervals, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setLhs(VirtualColumn lhs) throws ParserException {
        super.setLhs(lhs);
        CharSequence intervalStr = lhs.getFlyweightStr(null);
        if (intervalStr != null) {
            IntervalCompiler.parseIntervalEx(intervalStr, 0, intervalStr.length(), lhs.getPosition(), this.intervals);
        }
        this.intervalCount = this.intervals.size() / 2;
    }
}

