/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.regex;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.ql.ops.regex.Matcher;
import com.questdb.ql.ops.regex.Pattern;
import com.questdb.std.str.FlyweightCharSequence;

public class PluckStrFunction
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new PluckStrFunction(position);
    private final FlyweightCharSequence csA = new FlyweightCharSequence();
    private final FlyweightCharSequence csB = new FlyweightCharSequence();
    private Matcher matcher;

    private PluckStrFunction(int position) {
        super(7, position);
    }

    @Override
    public CharSequence getFlyweightStr(Record rec) {
        return this.getFlyweightStr0(this.rhs.getFlyweightStr(rec), this.csA);
    }

    @Override
    public CharSequence getFlyweightStrB(Record rec) {
        return this.getFlyweightStr0(this.rhs.getFlyweightStrB(rec), this.csB);
    }

    public CharSequence getFlyweightStr0(CharSequence base, FlyweightCharSequence to) {
        if (base != null && this.matcher.reset(base).find() && this.matcher.groupCount() > 0) {
            int lo = this.matcher.firstStartQuick();
            int hi = this.matcher.firstEndQuick();
            return to.of(base, lo, hi - lo);
        }
        return null;
    }

    @Override
    public void prepare(StorageFacade facade) {
        super.prepare(facade);
        this.matcher = Pattern.compile(this.lhs.getFlyweightStr(null).toString()).matcher("");
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        switch (pos) {
            case 0: {
                PluckStrFunction.assertConstant(arg);
                if (arg.getFlyweightStr(null) != null) break;
                throw QueryError.$(arg.getPosition(), "null pattern?");
            }
        }
        super.setArg(pos, arg);
    }
}

