/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.regex;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.ops.AbstractVirtualColumn;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.regex.Matcher;
import com.questdb.ql.ops.regex.Pattern;
import com.questdb.ql.ops.regex.PatternSyntaxException;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.ConcatCharSequence;
import com.questdb.std.str.FlyweightCharSequence;

class ReplaceStrFunction
extends AbstractVirtualColumn
implements Function {
    private FlyweightCharSequence left;
    private FlyweightCharSequence right;
    private ConcatCharSequence replacePattern;
    private VirtualColumn value;
    private Matcher matcher;
    private CharSequence base;
    private boolean trivial;

    public ReplaceStrFunction(int position) {
        super(7, position);
    }

    public static void main(String[] args) {
        String a = "2015-12-20";
        System.out.println(a.replaceAll("(.+)-", "x"));
    }

    @Override
    public CharSequence getFlyweightStr(Record rec) {
        this.base = this.value.getFlyweightStr(rec);
        boolean found = this.matcher.reset(this.base).find();
        if (this.trivial) {
            if (found) {
                this.left.of(this.base, 0, this.matcher.start());
                this.right.of(this.base, this.matcher.end(), this.base.length() - this.matcher.end());
            } else {
                return this.base;
            }
        }
        this.replacePattern.computeLen();
        return this.replacePattern;
    }

    @Override
    public CharSequence getFlyweightStrB(Record rec) {
        return this.getFlyweightStr(rec);
    }

    @Override
    public void getStr(Record rec, CharSink sink) {
        sink.put(this.getFlyweightStr(rec));
    }

    @Override
    public boolean isConstant() {
        return this.value.isConstant();
    }

    @Override
    public void prepare(StorageFacade facade) {
    }

    @Override
    public void setArg(int pos, VirtualColumn arg) throws ParserException {
        switch (pos) {
            case 0: {
                this.compileRegex(arg);
                break;
            }
            case 1: {
                this.compileReplacePattern(arg);
                break;
            }
            case 2: {
                this.value = arg;
                break;
            }
            default: {
                throw QueryError.$(arg.getPosition(), "unexpected argument");
            }
        }
    }

    private void compileRegex(VirtualColumn arg) throws ParserException {
        CharSequence pattern = arg.getFlyweightStr(null);
        if (pattern == null) {
            throw QueryError.$(arg.getPosition(), "null regex?");
        }
        try {
            this.matcher = Pattern.compile(pattern.toString()).matcher("");
        }
        catch (PatternSyntaxException e) {
            throw QueryError.position(arg.getPosition() + e.getIndex() + 2).$("Regex syntax error. ").$(e.getDescription()).$();
        }
    }

    private void compileReplacePattern(VirtualColumn arg) throws ParserException {
        CharSequence pattern = arg.getFlyweightStr(null);
        if (pattern == null) {
            throw QueryError.$(arg.getPosition(), "null pattern?");
        }
        int pos = arg.getPosition();
        int start = 0;
        int index = -1;
        int dollar = -2;
        int dollarCount = 0;
        ConcatCharSequence concat = new ConcatCharSequence();
        boolean collectIndex = false;
        int n = pattern.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '$': {
                    if (i == dollar + 1) {
                        throw QueryError.$(pos + i, "missing index");
                    }
                    if (i > start) {
                        concat.add(new FlyweightCharSequence().of(pattern, start, i - start));
                    }
                    collectIndex = true;
                    index = 0;
                    dollar = i;
                    ++dollarCount;
                    continue block3;
                }
                default: {
                    if (!collectIndex) continue block3;
                    int k = c - 48;
                    if (k > -1 && k < 10) {
                        index = index * 10 + k;
                        continue block3;
                    }
                    if (i == dollar + 1) {
                        throw QueryError.$(pos + i, "missing index");
                    }
                    concat.add(new GroupCharSequence(index));
                    start = i;
                    collectIndex = false;
                    index = -1;
                }
            }
        }
        if (collectIndex) {
            if (n == dollar + 1) {
                throw QueryError.$(pos + n, "missing index");
            }
            concat.add(new GroupCharSequence(index));
        } else if (start < n) {
            concat.add(new FlyweightCharSequence().of(pattern, start, n - start));
        }
        if (this.trivial = dollarCount == 0) {
            this.left = new FlyweightCharSequence();
            this.right = new FlyweightCharSequence();
            concat.surroundWith(this.left, this.right);
        }
        this.replacePattern = concat;
    }

    private class GroupCharSequence
    extends AbstractCharSequence {
        private final int lo;
        private final int hi;
        private final int max;

        public GroupCharSequence(int group) {
            this.lo = group * 2;
            this.hi = this.lo + 1;
            this.max = group - 1;
        }

        @Override
        public int length() {
            if (ReplaceStrFunction.this.base == null) {
                return 0;
            }
            if (this.max < ReplaceStrFunction.this.matcher.groupCount()) {
                int l = ReplaceStrFunction.this.matcher.groupQuick(this.lo);
                int h = ReplaceStrFunction.this.matcher.groupQuick(this.hi);
                return h - l;
            }
            return 0;
        }

        @Override
        public char charAt(int index) {
            return ReplaceStrFunction.this.base.charAt(index + ReplaceStrFunction.this.matcher.groupQuick(this.lo));
        }
    }
}

