/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.regex;

import com.questdb.common.Record;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.ops.AbstractBinaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.ql.ops.regex.Matcher;
import com.questdb.ql.ops.regex.Pattern;
import com.questdb.ql.ops.regex.PatternSyntaxException;

public class StrRegexOperator
extends AbstractBinaryOperator {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new StrRegexOperator(position);
    private Matcher matcher;

    private StrRegexOperator(int position) {
        super(0, position);
    }

    @Override
    public boolean getBool(Record rec) {
        CharSequence cs = this.lhs.getFlyweightStr(rec);
        return cs != null && this.matcher.reset(cs).find();
    }

    @Override
    public void setRhs(VirtualColumn rhs) throws ParserException {
        super.setRhs(rhs);
        CharSequence pattern = rhs.getFlyweightStr(null);
        if (pattern == null) {
            throw QueryError.$(rhs.getPosition(), "null regex?");
        }
        try {
            this.matcher = Pattern.compile(pattern.toString()).matcher("");
        }
        catch (PatternSyntaxException e) {
            throw QueryError.position(rhs.getPosition() + e.getIndex() + 2).$("Regex syntax error. ").$(e.getDescription()).$();
        }
    }
}

