/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.stat;

import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.ql.AggregatorFunction;
import com.questdb.ql.CollectionRecordMetadata;
import com.questdb.ql.RecordColumnMetadataImpl;
import com.questdb.ql.RecordList;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.MapRecordValueInterceptor;
import com.questdb.ql.ops.AbstractUnaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.store.factory.configuration.ColumnMetadata;
import java.io.Closeable;

public final class AvgAggregator
extends AbstractUnaryOperator
implements AggregatorFunction,
MapRecordValueInterceptor,
Closeable {
    public static final VirtualColumnFactory<Function> FACTORY = (position, configuration) -> new AvgAggregator(position);
    private static final RecordColumnMetadata INTERNAL_COL_TOTAL = new RecordColumnMetadataImpl("$total", 5);
    private static final RecordColumnMetadata INTERNAL_COL_LOCAL_TOTAL = new RecordColumnMetadataImpl("$local_total", 5);
    private static final RecordColumnMetadata INTERNAL_COL_SUM = new RecordColumnMetadataImpl("$sum", 2);
    private static final RecordColumnMetadata INTERNAL_COL_LIST_HEAD = new RecordColumnMetadataImpl("$listHead", 5);
    private static final RecordColumnMetadata INTERNAL_COL_LIST_TAIL = new RecordColumnMetadataImpl("$listTail", 5);
    private static final CollectionRecordMetadata listMetadata = new CollectionRecordMetadata();
    private final RecordList records = new RecordList(listMetadata, 0x100000);
    private int oTotal;
    private int oLocalTotal;
    private int oSum;
    private int oListHead;
    private int oListTail;
    private int oAvg;

    private AvgAggregator(int position) {
        super(2, position);
    }

    @Override
    public void beforeRecord(DirectMapValues values) {
        double d = values.getDouble(this.oAvg);
        if (d != d) {
            this.computeAvg(values);
        }
    }

    @Override
    public void calculate(Record rec, DirectMapValues values) {
        double sum;
        long localTotal;
        if (values.isNew()) {
            values.putLong(this.oTotal, 1L);
            values.putDouble(this.oAvg, Double.NaN);
            localTotal = 0L;
            sum = 0.0;
            values.putLong(this.oListHead, -1L);
            values.putLong(this.oListTail, -1L);
        } else {
            values.putLong(this.oTotal, values.getLong(this.oTotal) + 1L);
            localTotal = values.getLong(this.oLocalTotal);
            sum = values.getDouble(this.oSum);
        }
        double value = this.value.getDouble(rec);
        double x = sum + value;
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            long head = values.getLong(this.oListHead);
            long tail = values.getLong(this.oListTail);
            tail = this.records.beginRecord(tail);
            values.putLong(this.oListTail, tail);
            if (head == -1L) {
                values.putLong(this.oListHead, tail);
            }
            this.records.appendDouble(sum);
            this.records.appendLong(localTotal);
            values.putLong(this.oLocalTotal, 1L);
            values.putDouble(this.oSum, value);
        } else {
            values.putLong(this.oLocalTotal, localTotal + 1L);
            values.putDouble(this.oSum, x);
        }
    }

    @Override
    public void clear() {
        this.records.clear();
    }

    @Override
    public void prepare(ObjList<RecordColumnMetadata> columns, int offset) {
        columns.add(INTERNAL_COL_TOTAL);
        columns.add(INTERNAL_COL_LOCAL_TOTAL);
        columns.add(INTERNAL_COL_SUM);
        columns.add(INTERNAL_COL_LIST_HEAD);
        columns.add(INTERNAL_COL_LIST_TAIL);
        columns.add(new ColumnMetadata().setName(this.getName()).setType(2));
        this.oTotal = offset;
        this.oLocalTotal = offset + 1;
        this.oSum = offset + 2;
        this.oListHead = offset + 3;
        this.oListTail = offset + 4;
        this.oAvg = offset + 5;
    }

    @Override
    public void close() {
        Misc.free(this.records);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    private void computeAvg(DirectMapValues values) {
        long ref = values.getLong(this.oListHead);
        if (ref == -1L) {
            values.putDouble(this.oAvg, values.getDouble(this.oSum) / (double)values.getLong(this.oLocalTotal));
        } else {
            double total = values.getLong(this.oTotal);
            double count = values.getLong(this.oLocalTotal);
            double avg = count / total * (values.getDouble(this.oSum) / count);
            this.records.of(ref);
            while (this.records.hasNext()) {
                Record r = this.records.next();
                count = r.getLong(1);
                avg += count / total * (r.getDouble(0) / count);
            }
            values.putDouble(this.oAvg, avg);
        }
    }

    static {
        listMetadata.add(new RecordColumnMetadataImpl("sum", 2));
        listMetadata.add(new RecordColumnMetadataImpl("count", 5));
    }
}

