/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.ops.stat;

import com.questdb.ServerConfiguration;
import com.questdb.common.Record;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.ql.AggregatorFunction;
import com.questdb.ql.CollectionRecordMetadata;
import com.questdb.ql.RecordColumnMetadataImpl;
import com.questdb.ql.RecordList;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.MapRecordValueInterceptor;
import com.questdb.ql.ops.AbstractUnaryOperator;
import com.questdb.ql.ops.Function;
import com.questdb.ql.ops.VirtualColumnFactory;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.store.factory.configuration.ColumnMetadata;
import java.io.Closeable;

public class VarAggregator
extends AbstractUnaryOperator
implements AggregatorFunction,
MapRecordValueInterceptor,
Closeable {
    public static final VirtualColumnFactory<Function> FACTORY = (position, env) -> new VarAggregator(position, env.configuration);
    private static final RecordColumnMetadata INTERNAL_COL_TOTAL = new RecordColumnMetadataImpl("$total", 5);
    private static final RecordColumnMetadata INTERNAL_COL_LOCAL_TOTAL = new RecordColumnMetadataImpl("$part_total", 5);
    private static final RecordColumnMetadata INTERNAL_COL_SUM = new RecordColumnMetadataImpl("$part_sum", 2);
    private static final RecordColumnMetadata INTERNAL_COL_MEAN_HEAD = new RecordColumnMetadataImpl("$meanHead", 5);
    private static final RecordColumnMetadata INTERNAL_COL_MEAN_TAIL = new RecordColumnMetadataImpl("$meanTail", 5);
    private static final RecordColumnMetadata INTERNAL_COL_VALUES_HEAD = new RecordColumnMetadataImpl("$valuesHead", 5);
    private static final RecordColumnMetadata INTERNAL_COL_VALUES_TAIL = new RecordColumnMetadataImpl("$valuesTail", 5);
    private static final CollectionRecordMetadata meanPartialsMetadata = new CollectionRecordMetadata();
    private static final CollectionRecordMetadata sourceMetadata;
    private final RecordList meanPartials;
    private final RecordList srcRecords;
    private int oTotal;
    private int oPartialTotal;
    private int oPartialSum;
    private int oPartialHead;
    private int oPartialTail;
    private int oValuesHead;
    private int oValuesTail;
    private int oVariance;

    protected VarAggregator(int position, ServerConfiguration configuration) {
        super(2, position);
        this.meanPartials = new RecordList(meanPartialsMetadata, configuration.getDbFnVarianceMeans());
        this.srcRecords = new RecordList(sourceMetadata, configuration.getDbFnVarianceData());
    }

    @Override
    public void beforeRecord(DirectMapValues values) {
        double r = this.getResult(values);
        if (r != r) {
            r = this.computeVar(values);
            this.storeResult(values, r);
        }
    }

    @Override
    public void calculate(Record rec, DirectMapValues values) {
        double sum;
        long localTotal;
        if (values.isNew()) {
            values.putLong(this.oTotal, 1L);
            values.putDouble(this.oVariance, Double.NaN);
            localTotal = 0L;
            sum = 0.0;
            values.putLong(this.oPartialHead, -1L);
            values.putLong(this.oPartialTail, -1L);
            values.putLong(this.oValuesHead, -1L);
            values.putLong(this.oValuesTail, -1L);
        } else {
            values.putLong(this.oTotal, values.getLong(this.oTotal) + 1L);
            localTotal = values.getLong(this.oPartialTotal);
            sum = values.getDouble(this.oPartialSum);
        }
        double value = this.value.getDouble(rec);
        double x = sum + value;
        if (x == Double.POSITIVE_INFINITY || x == Double.NEGATIVE_INFINITY) {
            VarAggregator.beginRecord(values, this.oPartialHead, this.oPartialTail, this.meanPartials);
            this.meanPartials.appendDouble(sum);
            this.meanPartials.appendLong(localTotal);
            values.putLong(this.oPartialTotal, 1L);
            values.putDouble(this.oPartialSum, value);
        } else {
            values.putLong(this.oPartialTotal, localTotal + 1L);
            values.putDouble(this.oPartialSum, x);
        }
        VarAggregator.beginRecord(values, this.oValuesHead, this.oValuesTail, this.srcRecords);
        this.srcRecords.appendDouble(value);
    }

    @Override
    public void clear() {
        this.meanPartials.clear();
        this.srcRecords.clear();
    }

    @Override
    public void prepare(ObjList<RecordColumnMetadata> columns, int offset) {
        columns.add(INTERNAL_COL_TOTAL);
        columns.add(INTERNAL_COL_LOCAL_TOTAL);
        columns.add(INTERNAL_COL_SUM);
        columns.add(INTERNAL_COL_MEAN_HEAD);
        columns.add(INTERNAL_COL_MEAN_TAIL);
        columns.add(INTERNAL_COL_VALUES_HEAD);
        columns.add(INTERNAL_COL_VALUES_TAIL);
        columns.add(new ColumnMetadata().setName(this.getName()).setType(2));
        this.oTotal = offset;
        this.oPartialTotal = offset + 1;
        this.oPartialSum = offset + 2;
        this.oPartialHead = offset + 3;
        this.oPartialTail = offset + 4;
        this.oValuesHead = offset + 5;
        this.oValuesTail = offset + 6;
        this.oVariance = offset + 7;
    }

    @Override
    public void close() {
        Misc.free(this.meanPartials);
        Misc.free(this.srcRecords);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    private static void beginRecord(DirectMapValues values, int oHead, int oTail, RecordList list) {
        long head = values.getLong(oHead);
        long tail = values.getLong(oTail);
        tail = list.beginRecord(tail);
        values.putLong(oTail, tail);
        if (head == -1L) {
            values.putLong(oHead, tail);
        }
    }

    protected double computeVar(DirectMapValues values) {
        double mean;
        double total;
        long ref = values.getLong(this.oPartialHead);
        if (ref == -1L) {
            total = values.getLong(this.oPartialTotal);
            mean = values.getDouble(this.oPartialSum) / total;
        } else {
            total = values.getLong(this.oTotal);
            double count = values.getLong(this.oPartialTotal);
            mean = count / total * (values.getDouble(this.oPartialSum) / count);
            this.meanPartials.of(ref);
            while (this.meanPartials.hasNext()) {
                Record r = this.meanPartials.next();
                double sum = r.getDouble(0);
                count = r.getLong(1);
                mean += count / total * (sum / count);
            }
        }
        double variance = 0.0;
        double partialSum = 0.0;
        long partialCount = 0L;
        this.srcRecords.of(values.getLong(this.oValuesHead));
        while (this.srcRecords.hasNext()) {
            Record r = this.srcRecords.next();
            double d = r.getDouble(0);
            double x = (mean - d) * (mean - d);
            double y = x + partialSum;
            if (y == Double.POSITIVE_INFINITY || y == Double.NEGATIVE_INFINITY) {
                variance += (double)partialCount / total * (partialSum / (double)partialCount);
                partialSum = x;
                partialCount = 1L;
                continue;
            }
            partialSum = y;
            ++partialCount;
        }
        return variance += (double)partialCount / total * (partialSum / (double)partialCount);
    }

    protected double getResult(DirectMapValues values) {
        return values.getDouble(this.oVariance);
    }

    protected void storeResult(DirectMapValues values, double value) {
        values.putDouble(this.oVariance, value);
    }

    static {
        meanPartialsMetadata.add(new RecordColumnMetadataImpl("sum", 2));
        meanPartialsMetadata.add(new RecordColumnMetadataImpl("count", 5));
        sourceMetadata = new CollectionRecordMetadata();
        sourceMetadata.add(new RecordColumnMetadataImpl("value", 2));
    }
}

