/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.select;

import com.questdb.common.AbstractRecordMetadata;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordMetadata;
import com.questdb.ql.RecordColumnMetadataImpl;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Chars;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.store.factory.configuration.ColumnName;
import java.util.Arrays;

class SelectedColumnsMetadata
extends AbstractRecordMetadata {
    private final RecordMetadata delegate;
    private final RecordColumnMetadata[] columnMetadata;
    private final CharSequenceIntHashMap nameIndex;
    private int timestampIndex = -1;

    SelectedColumnsMetadata(RecordMetadata delegate, ObjList<CharSequence> names, CharSequenceHashSet aliases) {
        this.delegate = delegate;
        int k = names.size();
        this.nameIndex = new CharSequenceIntHashMap(k);
        this.columnMetadata = new RecordColumnMetadata[k];
        for (int i = 0; i < k; ++i) {
            CharSequence name = names.getQuick(i);
            CharSequence _newName = aliases == null ? null : aliases.get(i);
            String result = (_newName != null ? _newName : name).toString();
            int index = delegate.getColumnIndex(name);
            this.columnMetadata[i] = this.meta(delegate.getColumnQuick(index), result);
            this.nameIndex.put(result, i);
            if (index != delegate.getTimestampIndex()) continue;
            this.timestampIndex = i;
        }
    }

    SelectedColumnsMetadata(RecordMetadata delegate, ObjList<CharSequence> names) {
        this(delegate, names, null);
    }

    @Override
    public String getAlias() {
        return this.delegate.getAlias();
    }

    @Override
    public void setAlias(String alias) {
        this.delegate.setAlias(alias);
    }

    @Override
    public int getColumnCount() {
        return this.columnMetadata.length;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence name) {
        int index = this.nameIndex.get(name);
        if (index != -1) {
            return index;
        }
        String alias = this.getAlias();
        if (alias == null) {
            return -1;
        }
        ColumnName columnName = ColumnName.singleton(name);
        if (Chars.equalsNc(alias, columnName.alias())) {
            return this.nameIndex.get(columnName.name());
        }
        return -1;
    }

    @Override
    public RecordColumnMetadata getColumnQuick(int index) {
        return Unsafe.arrayGet(this.columnMetadata, index);
    }

    @Override
    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    public String toString() {
        return "SelectedColumnsMetadata{delegate=" + this.delegate + ", columnMetadata=" + Arrays.toString(this.columnMetadata) + '}';
    }

    private RecordColumnMetadata meta(RecordColumnMetadata from, String newName) {
        return new RecordColumnMetadataImpl(newName, from.getType(), from.getSymbolTable(), from.getBucketCount(), from.isIndexed());
    }
}

