/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.select;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.RecordSource;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.ql.select.SelectedColumnsMetadata;
import com.questdb.ql.select.SelectedColumnsRecord;
import com.questdb.ql.select.SelectedColumnsStorageFacade;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class SelectedColumnsRecordSource
extends AbstractCombinedRecordSource {
    private final RecordSource delegate;
    private final RecordMetadata metadata;
    private final SelectedColumnsRecord record;
    private final SelectedColumnsStorageFacade storageFacade;
    private RecordCursor cursor;

    public SelectedColumnsRecordSource(RecordSource delegate, ObjList<CharSequence> names, CharSequenceHashSet aliases) {
        this.delegate = delegate;
        RecordMetadata dm = delegate.getMetadata();
        this.metadata = new SelectedColumnsMetadata(dm, names, aliases);
        this.record = new SelectedColumnsRecord(dm, names);
        this.storageFacade = new SelectedColumnsStorageFacade(dm, names);
    }

    public SelectedColumnsRecordSource(RecordSource delegate, ObjList<CharSequence> names) {
        this.delegate = delegate;
        RecordMetadata dm = delegate.getMetadata();
        this.metadata = new SelectedColumnsMetadata(dm, names);
        this.record = new SelectedColumnsRecord(dm, names);
        this.storageFacade = new SelectedColumnsStorageFacade(dm, names);
    }

    @Override
    public void close() {
        Misc.free(this.delegate);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.cursor = this.delegate.prepareCursor(factory, cancellationHandler);
        this.storageFacade.of(this.cursor.getStorageFacade());
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return this.record.copy().of(this.delegate.newRecord());
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.cursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.cursor.toTop();
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public Record next() {
        return this.record.of((Record)this.cursor.next());
    }

    @Override
    public Record recordAt(long rowId) {
        return this.record.of(this.cursor.recordAt(rowId));
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursor.recordAt(((SelectedColumnsRecord)record).getBase(), atRowId);
    }

    @Override
    public boolean supportsRowIdAccess() {
        return this.delegate.supportsRowIdAccess();
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("SelectedColumnsRecordSource").put(',');
        sink.putQuoted("src").put(':').put(this.delegate);
        sink.put('}');
    }
}

