/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.sort;

import com.questdb.common.ColumnType;
import com.questdb.common.Record;
import com.questdb.common.RecordMetadata;
import com.questdb.ql.sort.RecordComparator;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Chars;
import com.questdb.std.IntList;
import com.questdb.std.Numbers;
import com.questdb.std.ex.JournalUnsupportedTypeException;

public class ComparatorCompiler {
    private final BytecodeAssembler asm;
    private final CharSequenceIntHashMap typeMap = new CharSequenceIntHashMap();
    private final CharSequenceIntHashMap methodMap = new CharSequenceIntHashMap();
    private final CharSequenceIntHashMap comparatorMap = new CharSequenceIntHashMap();
    private final IntList fieldIndices = new IntList();
    private final IntList fieldNameIndices = new IntList();
    private final IntList fieldTypeIndices = new IntList();
    private final IntList fieldRecordAccessorIndicesA = new IntList();
    private final IntList fieldRecordAccessorIndicesB = new IntList();
    private final IntList comparatorAccessorIndices = new IntList();
    private final IntList branches = new IntList();

    public ComparatorCompiler(BytecodeAssembler asm) {
        this.asm = asm;
    }

    public RecordComparator compile(RecordMetadata m, IntList keyColumnIndices) {
        assert (keyColumnIndices.size() < 1560);
        this.asm.init(RecordComparator.class);
        this.asm.setupPool();
        int stackMapTableIndex = this.asm.poolUtf8("StackMapTable");
        int thisClassIndex = this.asm.poolClass(this.asm.poolUtf8("questdbasm"));
        int interfaceClassIndex = this.asm.poolClass(RecordComparator.class);
        int recordClassIndex = this.asm.poolClass(Record.class);
        int compareNameIndex = this.asm.poolUtf8("compare");
        int compareDescIndex = this.asm.poolUtf8("(Lcom/questdb/common/Record;)I");
        this.poolFieldArtifacts(compareNameIndex, thisClassIndex, recordClassIndex, m, keyColumnIndices);
        int setLeftNameIndex = this.asm.poolUtf8("setLeft");
        int setLeftDescIndex = this.asm.poolUtf8("(Lcom/questdb/common/Record;)V");
        this.asm.finishPool();
        this.asm.defineClass(thisClassIndex);
        this.asm.interfaceCount(1);
        this.asm.putShort(interfaceClassIndex);
        this.asm.fieldCount(this.fieldNameIndices.size());
        int n = this.fieldNameIndices.size();
        for (int i = 0; i < n; ++i) {
            this.asm.defineField(this.fieldNameIndices.getQuick(i), this.fieldTypeIndices.getQuick(i));
        }
        this.asm.methodCount(3);
        this.asm.defineDefaultConstructor();
        this.instrumentSetLeftMethod(setLeftNameIndex, setLeftDescIndex, keyColumnIndices);
        this.instrumentCompareMethod(stackMapTableIndex, compareNameIndex, compareDescIndex, keyColumnIndices);
        this.asm.putShort(0);
        return (RecordComparator)this.asm.newInstance();
    }

    private void instrumentCompareMethod(int stackMapTableIndex, int nameIndex, int descIndex, IntList keyColumns) {
        this.branches.clear();
        int sz = keyColumns.size();
        this.asm.startMethod(nameIndex, descIndex, sz + 3, 3);
        for (int i = 0; i < sz; ++i) {
            if (i > 0) {
                this.asm.iload(2);
                this.branches.add(this.asm.ifne());
            }
            this.asm.aload(0);
            this.asm.getfield(this.fieldIndices.getQuick(i));
            this.asm.aload(1);
            int index = keyColumns.getQuick(i);
            this.asm.iconst((index > 0 ? index : -index) - 1);
            this.asm.invokeInterface(this.fieldRecordAccessorIndicesA.getQuick(i), 1);
            this.asm.invokeStatic(this.comparatorAccessorIndices.getQuick(i));
            if (index < 0) {
                this.asm.ineg();
            }
            this.asm.istore(2);
        }
        int p = this.asm.position();
        this.asm.iload(2);
        this.asm.ireturn();
        int n = this.branches.size();
        for (int i = 0; i < n; ++i) {
            this.asm.setJmp(this.branches.getQuick(i), p);
        }
        this.asm.endMethodCode();
        this.asm.putShort(0);
        this.asm.putShort(1);
        this.asm.startStackMapTables(stackMapTableIndex, 1);
        this.asm.append_frame(1, p - this.asm.getCodeStart());
        this.asm.putITEM_Integer();
        this.asm.endStackMapTables();
        this.asm.endMethod();
    }

    private void instrumentSetLeftMethod(int nameIndex, int descIndex, IntList keyColumns) {
        this.asm.startMethod(nameIndex, descIndex, 3, 2);
        int n = keyColumns.size();
        for (int i = 0; i < n; ++i) {
            this.asm.aload(0);
            this.asm.aload(1);
            int index = keyColumns.getQuick(i);
            this.asm.iconst((index > 0 ? index : -index) - 1);
            this.asm.invokeInterface(this.fieldRecordAccessorIndicesB.getQuick(i), 1);
            this.asm.putfield(this.fieldIndices.getQuick(i));
        }
        this.asm.return_();
        this.asm.endMethodCode();
        this.asm.putShort(0);
        this.asm.putShort(0);
        this.asm.endMethod();
    }

    private void poolFieldArtifacts(int compareMethodIndex, int thisClassIndex, int recordClassIndex, RecordMetadata m, IntList keyColumnIndices) {
        this.typeMap.clear();
        this.fieldIndices.clear();
        this.fieldNameIndices.clear();
        this.fieldTypeIndices.clear();
        this.fieldRecordAccessorIndicesA.clear();
        this.fieldRecordAccessorIndicesB.clear();
        this.comparatorAccessorIndices.clear();
        this.methodMap.clear();
        int n = keyColumnIndices.size();
        for (int i = 0; i < n; ++i) {
            Class comparatorClass;
            String getterNameA;
            String fieldType;
            String getterNameB = null;
            String comparatorDesc = null;
            int index = keyColumnIndices.getQuick(i);
            if (index < 0) {
                index = -index;
            }
            switch (m.getColumnQuick(--index).getType()) {
                case 0: {
                    fieldType = "Z";
                    getterNameA = "getBool";
                    comparatorClass = Boolean.class;
                    break;
                }
                case 1: {
                    fieldType = "B";
                    getterNameA = "get";
                    comparatorClass = Byte.class;
                    break;
                }
                case 2: {
                    fieldType = "D";
                    getterNameA = "getDouble";
                    comparatorClass = Numbers.class;
                    break;
                }
                case 3: {
                    fieldType = "F";
                    getterNameA = "getFloat";
                    comparatorClass = Numbers.class;
                    break;
                }
                case 4: {
                    fieldType = "I";
                    getterNameA = "getInt";
                    comparatorClass = Integer.class;
                    break;
                }
                case 5: 
                case 10: {
                    fieldType = "J";
                    getterNameA = "getLong";
                    comparatorClass = Long.class;
                    break;
                }
                case 6: {
                    fieldType = "S";
                    getterNameA = "getShort";
                    comparatorClass = Short.class;
                    break;
                }
                case 7: {
                    getterNameA = "getFlyweightStr";
                    getterNameB = "getFlyweightStrB";
                    fieldType = "Ljava/lang/CharSequence;";
                    comparatorClass = Chars.class;
                    break;
                }
                case 8: {
                    getterNameA = "getSym";
                    fieldType = "Ljava/lang/CharSequence;";
                    comparatorClass = Chars.class;
                    comparatorDesc = "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)I";
                    break;
                }
                default: {
                    throw new JournalUnsupportedTypeException(ColumnType.nameOf(m.getColumnQuick(index).getType()));
                }
            }
            int typeIndex = this.typeMap.get(fieldType);
            if (typeIndex == -1) {
                typeIndex = this.asm.poolUtf8(fieldType);
                this.typeMap.put(fieldType, typeIndex);
            }
            this.fieldTypeIndices.add(typeIndex);
            int nameIndex = this.asm.poolUtf8().put('f').put(i).$();
            this.fieldNameIndices.add(nameIndex);
            this.fieldIndices.add(this.asm.poolField(thisClassIndex, this.asm.poolNameAndType(nameIndex, typeIndex)));
            int methodIndex = this.asm.poolInterfaceMethod(recordClassIndex, getterNameA, "(I)" + fieldType);
            this.methodMap.putIfAbsent(getterNameA, methodIndex);
            this.fieldRecordAccessorIndicesA.add(methodIndex);
            if (getterNameB != null) {
                methodIndex = this.asm.poolInterfaceMethod(recordClassIndex, getterNameB, "(I)" + fieldType);
                this.methodMap.putIfAbsent(getterNameB, methodIndex);
            }
            this.fieldRecordAccessorIndicesB.add(methodIndex);
            int comparatorIndex = this.comparatorMap.get(comparatorClass.getName());
            if (comparatorIndex == -1) {
                int nt = this.asm.poolNameAndType(compareMethodIndex, comparatorDesc == null ? this.asm.poolUtf8().put('(').put(fieldType).put(fieldType).put(")I").$() : this.asm.poolUtf8(comparatorDesc));
                comparatorIndex = this.asm.poolMethod(this.asm.poolClass(comparatorClass), nt);
            }
            this.comparatorAccessorIndices.add(comparatorIndex);
        }
    }
}

