/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.sort;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.RecordList;
import com.questdb.ql.RecordSource;
import com.questdb.ql.join.hash.FakeRecord;
import com.questdb.ql.map.MapUtils;
import com.questdb.ql.ops.AbstractRecordSource;
import com.questdb.ql.sort.RecordComparator;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.MemoryPages;
import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;
import java.io.Closeable;

public class RBTreeSortedRecordSource
extends AbstractRecordSource
implements Mutable,
RecordSource,
Closeable {
    private static final int BLOCK_SIZE = 41;
    private static final int O_LEFT = 8;
    private static final int O_RIGHT = 16;
    private static final int O_COLOUR = 24;
    private static final int O_REF = 25;
    private static final int O_TOP = 33;
    private static final byte RED = 1;
    private static final byte BLACK = 0;
    private final RecordList recordList;
    private final MemoryPages mem;
    private final RecordComparator comparator;
    private final RecordSource delegate;
    private final TreeCursor cursor = new TreeCursor();
    private final FakeRecord fakeRecord = new FakeRecord();
    private final boolean byRowId;
    private final Record sourceRecord;
    private long root = -1L;
    private RecordCursor sourceCursor;

    public RBTreeSortedRecordSource(RecordSource delegate, RecordComparator comparator, int keyPageSize, int valuePageSize) {
        this.delegate = delegate;
        this.comparator = comparator;
        this.mem = new MemoryPages(keyPageSize);
        this.byRowId = delegate.supportsRowIdAccess();
        this.recordList = new RecordList(this.byRowId ? MapUtils.ROWID_RECORD_METADATA : delegate.getMetadata(), valuePageSize);
        this.sourceRecord = delegate.newRecord();
    }

    @Override
    public void clear() {
        this.root = -1L;
        this.mem.clear();
        this.recordList.clear();
    }

    @Override
    public void close() {
        Misc.free(this.delegate);
        Misc.free(this.recordList);
        Misc.free(this.mem);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.delegate.getMetadata();
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.clear();
        this.setSourceCursor(this.delegate.prepareCursor(factory, cancellationHandler));
        if (this.byRowId) {
            this.buildMapByRowId(this.sourceCursor, cancellationHandler);
        } else {
            this.buildMap(this.sourceCursor, cancellationHandler);
        }
        return this.setupCursor();
    }

    @Override
    public boolean supportsRowIdAccess() {
        return true;
    }

    @Override
    public Record getRecord() {
        return this.byRowId ? this.sourceRecord : this.recordList.getRecord();
    }

    public void put(Record record) {
        int cmp;
        long r;
        long parent;
        if (this.root == -1L) {
            this.putParent(record);
            return;
        }
        this.comparator.setLeft(record);
        long p = this.root;
        do {
            parent = p;
            r = RBTreeSortedRecordSource.refOf(p);
            cmp = this.comparator.compare(this.recordList.recordAt(r));
            if (cmp < 0) {
                p = RBTreeSortedRecordSource.leftOf(p);
                continue;
            }
            if (cmp > 0) {
                p = RBTreeSortedRecordSource.rightOf(p);
                continue;
            }
            RBTreeSortedRecordSource.setRef(p, this.recordList.append(record, r));
            return;
        } while (p > -1L);
        p = this.allocateBlock();
        RBTreeSortedRecordSource.setParent(p, parent);
        r = this.recordList.append(record, -1L);
        RBTreeSortedRecordSource.setTop(p, r);
        RBTreeSortedRecordSource.setRef(p, r);
        if (cmp < 0) {
            RBTreeSortedRecordSource.setLeft(parent, p);
        } else {
            RBTreeSortedRecordSource.setRight(parent, p);
        }
        this.fix(p);
    }

    public void put(long rowId) {
        int cmp;
        long r;
        long parent;
        if (this.root == -1L) {
            this.putParent(this.fakeRecord.of(rowId));
            return;
        }
        this.sourceCursor.recordAt(this.sourceRecord, rowId);
        this.comparator.setLeft(this.sourceRecord);
        long p = this.root;
        do {
            parent = p;
            r = RBTreeSortedRecordSource.refOf(p);
            this.sourceCursor.recordAt(this.sourceRecord, this.recordList.recordAt(r).getLong(0));
            cmp = this.comparator.compare(this.sourceRecord);
            if (cmp < 0) {
                p = RBTreeSortedRecordSource.leftOf(p);
                continue;
            }
            if (cmp > 0) {
                p = RBTreeSortedRecordSource.rightOf(p);
                continue;
            }
            RBTreeSortedRecordSource.setRef(p, this.recordList.append(this.fakeRecord.of(rowId), r));
            return;
        } while (p > -1L);
        p = this.allocateBlock();
        RBTreeSortedRecordSource.setParent(p, parent);
        r = this.recordList.append(this.fakeRecord.of(rowId), -1L);
        RBTreeSortedRecordSource.setTop(p, r);
        RBTreeSortedRecordSource.setRef(p, r);
        if (cmp < 0) {
            RBTreeSortedRecordSource.setLeft(parent, p);
        } else {
            RBTreeSortedRecordSource.setRight(parent, p);
        }
        this.fix(p);
    }

    public RecordCursor setupCursor() {
        this.cursor.setup();
        return this.cursor;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("RBTreeSortedRecordSource").put(',');
        sink.putQuoted("byRowId").put(':').put(this.byRowId).put(',');
        sink.putQuoted("src").put(':').put(this.delegate);
        sink.put('}');
    }

    private static void setLeft(long blockAddress, long left) {
        Unsafe.getUnsafe().putLong(blockAddress + 8L, left);
    }

    private static long rightOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 16L);
    }

    private static long leftOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 8L);
    }

    private static void setParent(long blockAddress, long parent) {
        Unsafe.getUnsafe().putLong(blockAddress, parent);
    }

    private static long refOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 25L);
    }

    private static long topOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress + 33L);
    }

    private static void setRef(long blockAddress, long recRef) {
        Unsafe.getUnsafe().putLong(blockAddress + 25L, recRef);
    }

    private static void setTop(long blockAddress, long recRef) {
        Unsafe.getUnsafe().putLong(blockAddress + 33L, recRef);
    }

    private static void setRight(long blockAddress, long right) {
        Unsafe.getUnsafe().putLong(blockAddress + 16L, right);
    }

    private static long parentOf(long blockAddress) {
        return blockAddress == -1L ? -1L : Unsafe.getUnsafe().getLong(blockAddress);
    }

    private static long parent2Of(long blockAddress) {
        return RBTreeSortedRecordSource.parentOf(RBTreeSortedRecordSource.parentOf(blockAddress));
    }

    private static void setColor(long blockAddress, byte colour) {
        if (blockAddress == -1L) {
            return;
        }
        Unsafe.getUnsafe().putByte(blockAddress + 24L, colour);
    }

    private static byte colorOf(long blockAddress) {
        return blockAddress == -1L ? (byte)0 : Unsafe.getUnsafe().getByte(blockAddress + 24L);
    }

    private static long successor(long current) {
        long p = RBTreeSortedRecordSource.rightOf(current);
        if (p != -1L) {
            long l;
            while ((l = RBTreeSortedRecordSource.leftOf(p)) != -1L) {
                p = l;
            }
        } else {
            p = RBTreeSortedRecordSource.parentOf(current);
            long ch = current;
            while (p != -1L && ch == RBTreeSortedRecordSource.rightOf(p)) {
                ch = p;
                p = RBTreeSortedRecordSource.parentOf(p);
            }
        }
        return p;
    }

    @Override
    public Record newRecord() {
        return this.byRowId ? this.delegate.newRecord() : this.recordList.newRecord();
    }

    private long allocateBlock() {
        long p = this.mem.allocate(41L);
        RBTreeSortedRecordSource.setLeft(p, -1L);
        RBTreeSortedRecordSource.setRight(p, -1L);
        RBTreeSortedRecordSource.setColor(p, (byte)0);
        return p;
    }

    private void buildMap(RecordCursor cursor, CancellationHandler cancellationHandler) {
        while (cursor.hasNext()) {
            cancellationHandler.check();
            this.put((Record)cursor.next());
        }
    }

    private void buildMapByRowId(RecordCursor cursor, CancellationHandler cancellationHandler) {
        while (cursor.hasNext()) {
            cancellationHandler.check();
            this.put(((Record)cursor.next()).getRowId());
        }
    }

    private void fix(long x) {
        RBTreeSortedRecordSource.setColor(x, (byte)1);
        while (x != -1L && x != this.root && RBTreeSortedRecordSource.colorOf(RBTreeSortedRecordSource.parentOf(x)) == 1) {
            long y;
            if (RBTreeSortedRecordSource.parentOf(x) == RBTreeSortedRecordSource.leftOf(RBTreeSortedRecordSource.parent2Of(x))) {
                y = RBTreeSortedRecordSource.rightOf(RBTreeSortedRecordSource.parent2Of(x));
                if (RBTreeSortedRecordSource.colorOf(y) == 1) {
                    RBTreeSortedRecordSource.setColor(RBTreeSortedRecordSource.parentOf(x), (byte)0);
                    RBTreeSortedRecordSource.setColor(y, (byte)0);
                    RBTreeSortedRecordSource.setColor(RBTreeSortedRecordSource.parent2Of(x), (byte)1);
                    x = RBTreeSortedRecordSource.parent2Of(x);
                    continue;
                }
                if (x == RBTreeSortedRecordSource.rightOf(RBTreeSortedRecordSource.parentOf(x))) {
                    x = RBTreeSortedRecordSource.parentOf(x);
                    this.rotateLeft(x);
                }
                RBTreeSortedRecordSource.setColor(RBTreeSortedRecordSource.parentOf(x), (byte)0);
                RBTreeSortedRecordSource.setColor(RBTreeSortedRecordSource.parent2Of(x), (byte)1);
                this.rotateRight(RBTreeSortedRecordSource.parent2Of(x));
                continue;
            }
            y = RBTreeSortedRecordSource.leftOf(RBTreeSortedRecordSource.parent2Of(x));
            if (RBTreeSortedRecordSource.colorOf(y) == 1) {
                RBTreeSortedRecordSource.setColor(RBTreeSortedRecordSource.parentOf(x), (byte)0);
                RBTreeSortedRecordSource.setColor(y, (byte)0);
                RBTreeSortedRecordSource.setColor(RBTreeSortedRecordSource.parent2Of(x), (byte)1);
                x = RBTreeSortedRecordSource.parent2Of(x);
                continue;
            }
            if (x == RBTreeSortedRecordSource.leftOf(RBTreeSortedRecordSource.parentOf(x))) {
                x = RBTreeSortedRecordSource.parentOf(x);
                this.rotateRight(x);
            }
            RBTreeSortedRecordSource.setColor(RBTreeSortedRecordSource.parentOf(x), (byte)0);
            RBTreeSortedRecordSource.setColor(RBTreeSortedRecordSource.parent2Of(x), (byte)1);
            this.rotateLeft(RBTreeSortedRecordSource.parent2Of(x));
        }
        RBTreeSortedRecordSource.setColor(this.root, (byte)0);
    }

    private void putParent(Record record) {
        this.root = this.allocateBlock();
        long r = this.recordList.append(record, -1L);
        RBTreeSortedRecordSource.setTop(this.root, r);
        RBTreeSortedRecordSource.setRef(this.root, r);
        RBTreeSortedRecordSource.setParent(this.root, -1L);
        RBTreeSortedRecordSource.setLeft(this.root, -1L);
        RBTreeSortedRecordSource.setRight(this.root, -1L);
    }

    private void rotateLeft(long p) {
        if (p != -1L) {
            long r = RBTreeSortedRecordSource.rightOf(p);
            RBTreeSortedRecordSource.setRight(p, RBTreeSortedRecordSource.leftOf(r));
            if (RBTreeSortedRecordSource.leftOf(r) != -1L) {
                RBTreeSortedRecordSource.setParent(RBTreeSortedRecordSource.leftOf(r), p);
            }
            RBTreeSortedRecordSource.setParent(r, RBTreeSortedRecordSource.parentOf(p));
            if (RBTreeSortedRecordSource.parentOf(p) == -1L) {
                this.root = r;
            } else if (RBTreeSortedRecordSource.leftOf(RBTreeSortedRecordSource.parentOf(p)) == p) {
                RBTreeSortedRecordSource.setLeft(RBTreeSortedRecordSource.parentOf(p), r);
            } else {
                RBTreeSortedRecordSource.setRight(RBTreeSortedRecordSource.parentOf(p), r);
            }
            RBTreeSortedRecordSource.setLeft(r, p);
            RBTreeSortedRecordSource.setParent(p, r);
        }
    }

    private void rotateRight(long p) {
        if (p != -1L) {
            long l = RBTreeSortedRecordSource.leftOf(p);
            RBTreeSortedRecordSource.setLeft(p, RBTreeSortedRecordSource.rightOf(l));
            if (RBTreeSortedRecordSource.rightOf(l) != -1L) {
                RBTreeSortedRecordSource.setParent(RBTreeSortedRecordSource.rightOf(l), p);
            }
            RBTreeSortedRecordSource.setParent(l, RBTreeSortedRecordSource.parentOf(p));
            if (RBTreeSortedRecordSource.parentOf(p) == -1L) {
                this.root = l;
            } else if (RBTreeSortedRecordSource.rightOf(RBTreeSortedRecordSource.parentOf(p)) == p) {
                RBTreeSortedRecordSource.setRight(RBTreeSortedRecordSource.parentOf(p), l);
            } else {
                RBTreeSortedRecordSource.setLeft(RBTreeSortedRecordSource.parentOf(p), l);
            }
            RBTreeSortedRecordSource.setRight(l, p);
            RBTreeSortedRecordSource.setParent(p, l);
        }
    }

    private void setSourceCursor(RecordCursor sourceCursor) {
        this.sourceCursor = sourceCursor;
        this.recordList.setStorageFacade(sourceCursor.getStorageFacade());
    }

    private class TreeCursor
    implements RecordCursor,
    ImmutableIterator<Record> {
        private long current;

        private TreeCursor() {
        }

        @Override
        public StorageFacade getStorageFacade() {
            return RBTreeSortedRecordSource.this.recordList.getStorageFacade();
        }

        @Override
        public Record recordAt(long rowId) {
            return RBTreeSortedRecordSource.this.byRowId ? RBTreeSortedRecordSource.this.sourceCursor.recordAt(rowId) : RBTreeSortedRecordSource.this.recordList.recordAt(rowId);
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            if (RBTreeSortedRecordSource.this.byRowId) {
                RBTreeSortedRecordSource.this.sourceCursor.recordAt(record, atRowId);
            } else {
                RBTreeSortedRecordSource.this.recordList.recordAt(record, atRowId);
            }
        }

        @Override
        public void releaseCursor() {
            RBTreeSortedRecordSource.this.sourceCursor.releaseCursor();
            RBTreeSortedRecordSource.this.recordList.releaseCursor();
        }

        @Override
        public void toTop() {
            this.setup();
            RBTreeSortedRecordSource.this.sourceCursor.toTop();
        }

        @Override
        public boolean hasNext() {
            if (RBTreeSortedRecordSource.this.recordList.hasNext()) {
                return true;
            }
            this.current = RBTreeSortedRecordSource.successor(this.current);
            if (this.current == -1L) {
                return false;
            }
            RBTreeSortedRecordSource.this.recordList.of(RBTreeSortedRecordSource.topOf(this.current));
            return true;
        }

        @Override
        public Record next() {
            Record underlying = RBTreeSortedRecordSource.this.recordList.next();
            if (RBTreeSortedRecordSource.this.byRowId) {
                RBTreeSortedRecordSource.this.sourceCursor.recordAt(RBTreeSortedRecordSource.this.sourceRecord, underlying.getLong(0));
                return RBTreeSortedRecordSource.this.sourceRecord;
            }
            return underlying;
        }

        private void setup() {
            long p = RBTreeSortedRecordSource.this.root;
            if (p != -1L) {
                while (RBTreeSortedRecordSource.leftOf(p) != -1L) {
                    p = RBTreeSortedRecordSource.leftOf(p);
                }
            }
            this.current = p;
            RBTreeSortedRecordSource.this.recordList.of(RBTreeSortedRecordSource.topOf(this.current));
        }

        @Override
        public Record getRecord() {
            return RBTreeSortedRecordSource.this.getRecord();
        }

        @Override
        public Record newRecord() {
            return RBTreeSortedRecordSource.this.newRecord();
        }
    }
}

