/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.sys;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.MasterStorageFacade;
import com.questdb.ql.RecordList;
import com.questdb.ql.ops.AbstractRecordSource;
import com.questdb.ql.sys.$ColsRecordMetadata;
import com.questdb.std.Files;
import com.questdb.std.Misc;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectCharSequence;
import com.questdb.std.str.NativeLPSZ;
import com.questdb.std.str.Path;
import com.questdb.store.factory.ReaderFactory;

public class $ColsRecordSource
extends AbstractRecordSource {
    private static final Log LOG = LogFactory.getLog($ColsRecordSource.class);
    private static final ThreadLocal<Path> tlPath = ThreadLocal.withInitial(Path::new);
    private static final ThreadLocal<Path> tlCompositePath = ThreadLocal.withInitial(Path::new);
    private static final ThreadLocal<NativeLPSZ> tlNativeLpsz = ThreadLocal.withInitial(NativeLPSZ::new);
    private static final ThreadLocal<DirectCharSequence> tlDcs = ThreadLocal.withInitial(DirectCharSequence::new);
    private final RecordMetadata metadata = new $ColsRecordMetadata();
    private final RecordList records;
    private final int metaSize;
    private final int maxMetaSize;

    public $ColsRecordSource(int pageSize, int metaSize, int maxMetaSize) {
        this.records = new RecordList(this.metadata, pageSize);
        this.records.setStorageFacade(new MasterStorageFacade().of(this.metadata));
        this.metaSize = metaSize;
        this.maxMetaSize = maxMetaSize;
    }

    public static void init() {
        tlPath.get();
        tlCompositePath.get();
    }

    @Override
    public void close() {
        Misc.free(this.records);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        block16: {
            this.records.clear();
            NativeLPSZ name = tlNativeLpsz.get();
            int bufSz = this.metaSize;
            long buf = Unsafe.malloc(bufSz);
            DirectCharSequence dcs = tlDcs.get();
            try {
                String base = factory.getConfiguration().getJournalBase().getAbsolutePath();
                Path path = tlPath.get().of(base).$();
                long find = Files.findFirst(path);
                if (find <= 0L) break block16;
                try {
                    long p = -1L;
                    Path compositePath = tlCompositePath.get();
                    do {
                        cancellationHandler.check();
                        if (Files.findType(find) != 4) continue;
                        name.of(Files.findName(find));
                        if (Files.isDots(name)) continue;
                        compositePath.of(base).concat(name).concat("_meta2").$();
                        if (!Files.exists(compositePath)) continue;
                        long fd = Files.openRO(compositePath);
                        if (fd < 0L) {
                            LOG.error().$("Cannot open: ").$(compositePath).$(" [").$(Os.errno()).$(']').$();
                            continue;
                        }
                        try {
                            long len = Files.length(compositePath);
                            if (len > (long)this.maxMetaSize) {
                                LOG.error().$("File : ").$(compositePath).$(" is too large [").$(len).$(']').$();
                                continue;
                            }
                            if (len > (long)bufSz) {
                                Unsafe.free(buf, bufSz);
                                bufSz = (int)len;
                                buf = Unsafe.malloc(bufSz);
                            }
                            Files.read(fd, buf, (int)len, 0L);
                            long readPtr = buf + 8L;
                            readPtr += (long)(Unsafe.getUnsafe().getInt(readPtr) * 2 + 4);
                            int partitionBy = Unsafe.getUnsafe().getInt(readPtr);
                            int columnCount = Unsafe.getUnsafe().getInt(readPtr + 4L);
                            int timestampIndex = Unsafe.getUnsafe().getInt(readPtr + 8L);
                            readPtr += 12L;
                            for (int i = 0; i < columnCount; ++i) {
                                p = this.records.beginRecord(p);
                                this.records.appendStr(name);
                                int l = Unsafe.getUnsafe().getInt(readPtr) * 2;
                                this.records.appendStr(dcs.of(readPtr += 4L, readPtr + (long)l));
                                this.records.appendInt(Unsafe.getUnsafe().getInt(readPtr += (long)l));
                                this.records.appendBool(i == timestampIndex);
                                this.records.appendInt(i == timestampIndex ? partitionBy : -1);
                                this.records.appendBool(Unsafe.getBool(readPtr += 12L));
                                this.records.appendInt(Unsafe.getUnsafe().getInt(readPtr += 9L));
                                l = Unsafe.getUnsafe().getInt(readPtr += 4L);
                                readPtr += 4L;
                                if (l > -1) {
                                    readPtr += (long)(l * 2);
                                }
                                ++readPtr;
                            }
                        }
                        finally {
                            Files.close(fd);
                        }
                    } while (Files.findNext(find) > 0);
                }
                finally {
                    Files.findClose(find);
                }
            }
            finally {
                Unsafe.free(buf, bufSz);
            }
        }
        this.records.toTop();
        return this.records;
    }

    @Override
    public boolean supportsRowIdAccess() {
        return false;
    }

    @Override
    public Record getRecord() {
        return this.records.getRecord();
    }

    @Override
    public Record newRecord() {
        return this.records.newRecord();
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("$cols");
        sink.put('}');
    }
}

