/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.sys;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.MasterStorageFacade;
import com.questdb.ql.RecordList;
import com.questdb.ql.ops.AbstractRecordSource;
import com.questdb.ql.sys.$TabsRecordMetadata;
import com.questdb.std.Files;
import com.questdb.std.Misc;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.NativeLPSZ;
import com.questdb.std.str.Path;
import com.questdb.store.factory.ReaderFactory;

public class $TabsRecordSource
extends AbstractRecordSource {
    private static final Log LOG = LogFactory.getLog($TabsRecordSource.class);
    private static final ThreadLocal<Path> tlPath = ThreadLocal.withInitial(Path::new);
    private static final ThreadLocal<Path> tlCompositePath = ThreadLocal.withInitial(Path::new);
    private static final ThreadLocal<NativeLPSZ> tlNativeLpsz = ThreadLocal.withInitial(NativeLPSZ::new);
    private final RecordList records;
    private final $TabsRecordMetadata metadata = new $TabsRecordMetadata();
    private final int metaSize;
    private final int maxMetaSize;

    public $TabsRecordSource(int pageSize, int metaSize, int maxMetaSize) {
        this.records = new RecordList(this.metadata, pageSize);
        this.records.setStorageFacade(new MasterStorageFacade().of(this.metadata));
        this.metaSize = metaSize;
        this.maxMetaSize = maxMetaSize;
    }

    public static void init() {
        tlPath.get();
        tlCompositePath.get();
    }

    @Override
    public void close() {
        Misc.free(this.records);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        block14: {
            this.records.clear();
            NativeLPSZ name = tlNativeLpsz.get();
            int bufSz = this.metaSize;
            long buf = Unsafe.malloc(bufSz);
            try {
                String base = factory.getConfiguration().getJournalBase().getAbsolutePath();
                Path path = tlPath.get().of(base).$();
                long find = Files.findFirst(path);
                if (find <= 0L) break block14;
                try {
                    long p = -1L;
                    Path compositePath = tlCompositePath.get();
                    do {
                        int columnCount;
                        int partitionBy;
                        cancellationHandler.check();
                        if (Files.findType(find) != 4) continue;
                        name.of(Files.findName(find));
                        if (Files.isDots(name)) continue;
                        long lastModified = Files.getLastModified(compositePath.of(base).concat(name).$());
                        compositePath.of(base).concat(name).concat("_meta2").$();
                        if (!Files.exists(compositePath)) continue;
                        long fd = Files.openRO(compositePath);
                        if (fd < 0L) {
                            LOG.error().$("Cannot open: ").$(compositePath).$(" [").$(Os.errno()).$(']').$();
                            continue;
                        }
                        try {
                            long len = Files.length(compositePath);
                            if (len > (long)this.maxMetaSize) {
                                LOG.error().$("File : ").$(compositePath).$(" is too large [").$(len).$(']').$();
                                continue;
                            }
                            if (len > (long)bufSz) {
                                Unsafe.free(buf, bufSz);
                                bufSz = (int)len;
                                buf = Unsafe.malloc(bufSz);
                            }
                            Files.read(fd, buf, (int)len, 0L);
                            long readPtr = buf + 8L;
                            readPtr += (long)(Unsafe.getUnsafe().getInt(readPtr) * 2 + 4);
                            partitionBy = Unsafe.getUnsafe().getInt(readPtr);
                            columnCount = Unsafe.getUnsafe().getInt(readPtr + 4L);
                        }
                        finally {
                            Files.close(fd);
                        }
                        p = this.records.beginRecord(p);
                        this.records.appendStr(name);
                        this.records.appendInt(partitionBy);
                        this.records.appendInt($TabsRecordSource.countDirs(compositePath.of(base).concat(name).$()));
                        this.records.appendInt(columnCount);
                        this.records.appendLong(lastModified);
                        this.records.appendLong($TabsRecordSource.sumSizes(compositePath));
                    } while (Files.findNext(find) > 0);
                }
                finally {
                    Files.findClose(find);
                }
            }
            finally {
                Unsafe.free(buf, bufSz);
            }
        }
        this.records.toTop();
        return this.records;
    }

    @Override
    public boolean supportsRowIdAccess() {
        return false;
    }

    @Override
    public Record getRecord() {
        return this.records.getRecord();
    }

    @Override
    public Record newRecord() {
        return this.records.newRecord();
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("$tabs");
        sink.put('}');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int countDirs(LPSZ path) {
        int count = 0;
        long find = Files.findFirst(path);
        if (find == 0L) {
            return 0;
        }
        NativeLPSZ file = tlNativeLpsz.get();
        try {
            do {
                file.of(Files.findName(find));
                if (Files.isDots(file) || Files.findType(find) != 4) continue;
                ++count;
            } while (Files.findNext(find) > 0);
        }
        finally {
            Files.findClose(find);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long sumSizes(LPSZ path) {
        long total = 0L;
        long find = Files.findFirst(path);
        if (find == 0L) {
            return 0L;
        }
        try (Path cp = new Path();){
            NativeLPSZ file = tlNativeLpsz.get();
            try {
                do {
                    file.of(Files.findName(find));
                    if (Files.isDots(file)) continue;
                    Path n = cp.of(path).concat(file).$();
                    if (Files.findType(find) == 4) {
                        total += $TabsRecordSource.sumSizes(n);
                        continue;
                    }
                    total += Files.length(n);
                } while (Files.findNext(find) > 0);
            }
            finally {
                Files.findClose(find);
            }
        }
        return total;
    }
}

