/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.virtual;

import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.common.StorageFacade;
import com.questdb.common.SymbolTable;
import com.questdb.ql.CancellationHandler;
import com.questdb.ql.RecordSource;
import com.questdb.ql.join.SplitRecordStorageFacade;
import com.questdb.ql.ops.AbstractCombinedRecordSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.virtual.VirtualRecord;
import com.questdb.ql.virtual.VirtualRecordMetadata;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.ReaderFactory;

public class VirtualColumnRecordSource
extends AbstractCombinedRecordSource {
    private final RecordSource delegate;
    private final RecordMetadata metadata;
    private final VirtualRecord record;
    private final SplitRecordStorageFacade storageFacade;
    private final VirtualColumnStorageFacade virtualColumnStorageFacade;
    private final ObjList<VirtualColumn> virtualColumns;
    private RecordCursor cursor;

    public VirtualColumnRecordSource(RecordSource delegate, ObjList<VirtualColumn> virtualColumns) {
        this.delegate = delegate;
        this.virtualColumns = virtualColumns;
        RecordMetadata dm = delegate.getMetadata();
        this.metadata = new VirtualRecordMetadata(dm, virtualColumns);
        this.record = new VirtualRecord(dm.getColumnCount(), virtualColumns, delegate.getRecord());
        this.virtualColumnStorageFacade = new VirtualColumnStorageFacade();
        this.storageFacade = new SplitRecordStorageFacade(dm.getColumnCount());
    }

    @Override
    public void close() {
        Misc.free(this.delegate);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public RecordCursor prepareCursor(ReaderFactory factory, CancellationHandler cancellationHandler) {
        this.cursor = this.delegate.prepareCursor(factory, cancellationHandler);
        this.storageFacade.prepare(this.cursor.getStorageFacade(), this.virtualColumnStorageFacade);
        this.record.prepare(this.storageFacade);
        return this;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record newRecord() {
        return this.record.copy(this.delegate.newRecord());
    }

    @Override
    public StorageFacade getStorageFacade() {
        return this.storageFacade;
    }

    @Override
    public void releaseCursor() {
        this.cursor.releaseCursor();
    }

    @Override
    public void toTop() {
        this.cursor.toTop();
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public Record next() {
        this.cursor.next();
        return this.record;
    }

    @Override
    public Record recordAt(long rowId) {
        this.cursor.recordAt(rowId);
        return this.record;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursor.recordAt(((VirtualRecord)record).getBase(), atRowId);
    }

    @Override
    public boolean supportsRowIdAccess() {
        return this.delegate.supportsRowIdAccess();
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('{');
        sink.putQuoted("op").put(':').putQuoted("VirtualColumnRecordSource").put(',');
        sink.putQuoted("src").put(':').put(this.delegate);
        sink.put('}');
    }

    private class VirtualColumnStorageFacade
    implements StorageFacade {
        private VirtualColumnStorageFacade() {
        }

        @Override
        public SymbolTable getSymbolTable(int index) {
            return ((VirtualColumn)VirtualColumnRecordSource.this.virtualColumns.getQuick(index)).getSymbolTable();
        }
    }
}

