/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.virtual;

import com.questdb.common.Record;
import com.questdb.common.StorageFacade;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.DirectInputStream;
import com.questdb.std.ObjList;
import java.io.OutputStream;

class VirtualRecord
implements Record {
    private final int split;
    private final ObjList<VirtualColumn> virtualColumns;
    private final Record base;

    VirtualRecord(int split, ObjList<VirtualColumn> virtualColumns, Record base) {
        this.split = split;
        this.virtualColumns = virtualColumns;
        this.base = base;
    }

    @Override
    public byte get(int col) {
        return col < this.split ? this.base.get(col) : this.getVc(col).get(this.base);
    }

    @Override
    public void getBin(int col, OutputStream s) {
        if (col < this.split) {
            this.base.getBin(col, s);
        } else {
            this.getVc(col).getBin(this.base, s);
        }
    }

    @Override
    public DirectInputStream getBin(int col) {
        return col < this.split ? this.base.getBin(col) : this.getVc(col).getBin(this.base);
    }

    @Override
    public long getBinLen(int col) {
        return col < this.split ? this.base.getBinLen(col) : this.getVc(col).getBinLen(this.base);
    }

    @Override
    public boolean getBool(int col) {
        return col < this.split ? this.base.getBool(col) : this.getVc(col).getBool(this.base);
    }

    @Override
    public long getDate(int col) {
        return col < this.split ? this.base.getDate(col) : this.getVc(col).getDate(this.base);
    }

    @Override
    public double getDouble(int col) {
        return col < this.split ? this.base.getDouble(col) : this.getVc(col).getDouble(this.base);
    }

    @Override
    public float getFloat(int col) {
        return col < this.split ? this.base.getFloat(col) : this.getVc(col).getFloat(this.base);
    }

    @Override
    public CharSequence getFlyweightStr(int col) {
        return col < this.split ? this.base.getFlyweightStr(col) : this.getVc(col).getFlyweightStr(this.base);
    }

    @Override
    public CharSequence getFlyweightStrB(int col) {
        return col < this.split ? this.base.getFlyweightStrB(col) : this.getVc(col).getFlyweightStrB(this.base);
    }

    @Override
    public int getInt(int col) {
        return col < this.split ? this.base.getInt(col) : this.getVc(col).getInt(this.base);
    }

    @Override
    public long getLong(int col) {
        return col < this.split ? this.base.getLong(col) : this.getVc(col).getLong(this.base);
    }

    @Override
    public long getRowId() {
        return this.base.getRowId();
    }

    @Override
    public short getShort(int col) {
        return col < this.split ? this.base.getShort(col) : this.getVc(col).getShort(this.base);
    }

    @Override
    public int getStrLen(int col) {
        return col < this.split ? this.base.getStrLen(col) : this.getVc(col).getStrLen(this.base);
    }

    @Override
    public CharSequence getSym(int col) {
        return col < this.split ? this.base.getSym(col) : this.getVc(col).getSym(this.base);
    }

    public Record getBase() {
        return this.base;
    }

    public void prepare(StorageFacade facade) {
        int n = this.virtualColumns.size();
        for (int i = 0; i < n; ++i) {
            this.virtualColumns.getQuick(i).prepare(facade);
        }
    }

    VirtualRecord copy(Record base) {
        return new VirtualRecord(this.split, this.virtualColumns, base);
    }

    private VirtualColumn getVc(int col) {
        return this.virtualColumns.getQuick(col - this.split);
    }
}

