/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.virtual;

import com.questdb.common.AbstractRecordMetadata;
import com.questdb.common.RecordColumnMetadata;
import com.questdb.common.RecordMetadata;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.ObjList;

public class VirtualRecordMetadata
extends AbstractRecordMetadata {
    private final RecordMetadata delegate;
    private final ObjList<VirtualColumn> virtualColumns;
    private final int split;
    private final CharSequenceIntHashMap nameToIndexMap = new CharSequenceIntHashMap();

    public VirtualRecordMetadata(RecordMetadata delegate, ObjList<VirtualColumn> virtualColumns) {
        this.delegate = delegate;
        this.split = delegate.getColumnCount();
        this.virtualColumns = virtualColumns;
        int k = virtualColumns.size();
        for (int i = 0; i < k; ++i) {
            this.nameToIndexMap.put(virtualColumns.getQuick(i).getName(), i + this.split);
        }
    }

    @Override
    public String getAlias() {
        return this.delegate.getAlias();
    }

    @Override
    public void setAlias(String alias) {
        this.delegate.setAlias(alias);
    }

    @Override
    public int getColumnCount() {
        return this.delegate.getColumnCount() + this.virtualColumns.size();
    }

    @Override
    public int getColumnIndexQuiet(CharSequence name) {
        int index = this.nameToIndexMap.get(name);
        return index == -1 ? this.delegate.getColumnIndexQuiet(name) : index;
    }

    @Override
    public RecordColumnMetadata getColumnQuick(int index) {
        return index < this.split ? this.delegate.getColumnQuick(index) : (RecordColumnMetadata)this.virtualColumns.getQuick(index - this.split);
    }

    @Override
    public int getTimestampIndex() {
        return this.delegate.getTimestampIndex();
    }
}

