/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Chars;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.io.Closeable;

public class AssociativeCache<V>
implements Closeable {
    private static final int MIN_BLOCKS = 2;
    private static final int NOT_FOUND = -1;
    private static final int MINROWS = 16;
    private final CharSequence[] keys;
    private final V[] values;
    private final int rmask;
    private final int bmask;
    private final int blocks;
    private final int bshift;

    public AssociativeCache(int blocks, int rows) {
        this.blocks = Math.max(2, Numbers.ceilPow2(blocks));
        rows = Math.max(16, Numbers.ceilPow2(rows));
        int size = rows * this.blocks;
        if (size < 0) {
            throw new OutOfMemoryError();
        }
        this.keys = new CharSequence[size];
        this.values = new Object[size];
        this.rmask = rows - 1;
        this.bmask = this.blocks - 1;
        this.bshift = Numbers.msb(this.blocks);
    }

    @Override
    public void close() {
        this.clear();
    }

    public V peek(CharSequence key) {
        int index = this.getIndex(key);
        if (index == -1) {
            return null;
        }
        return Unsafe.arrayGet(this.values, index);
    }

    public V poll(CharSequence key) {
        int index = this.getIndex(key);
        if (index == -1) {
            return null;
        }
        V value = Unsafe.arrayGet(this.values, index);
        Unsafe.arrayPut(this.values, index, null);
        Unsafe.arrayPut(this.keys, index, null);
        return value;
    }

    public CharSequence put(CharSequence key, V value) {
        int lo = this.lo(key);
        CharSequence ok = Unsafe.arrayGet(this.keys, lo + this.bmask);
        if (ok != null) {
            this.free(lo + this.bmask);
        }
        System.arraycopy(this.keys, lo, this.keys, lo + 1, this.bmask);
        System.arraycopy(this.values, lo, this.values, lo + 1, this.bmask);
        Unsafe.arrayPut(this.keys, lo, key);
        Unsafe.arrayPut(this.values, lo, value);
        return ok;
    }

    private void clear() {
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == null) continue;
            this.keys[i] = null;
            this.free(i);
        }
    }

    private void free(int lo) {
        Unsafe.arrayPut(this.values, lo, Misc.free(Unsafe.arrayGet(this.values, lo)));
    }

    private int getIndex(CharSequence key) {
        int lo;
        int hi = lo + this.blocks;
        for (int i = lo = this.lo(key); i < hi; ++i) {
            CharSequence k = Unsafe.arrayGet(this.keys, i);
            if (k == null) {
                return -1;
            }
            if (!Chars.equals(k, key)) continue;
            return i;
        }
        return -1;
    }

    private int lo(CharSequence key) {
        return (Chars.hashCode(key) & this.rmask) << this.bshift;
    }
}

