/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.NetworkChannel;
import com.questdb.std.Numbers;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.EndOfChannelException;
import com.questdb.std.ex.JournalDisconnectedChannelException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.std.ex.SlowReadableChannelException;
import com.questdb.std.ex.SlowWritableChannelException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import sun.nio.ch.DirectBuffer;

public final class ByteBuffers {
    private static final int[] multipliers = new int[]{1, 3};

    private ByteBuffers() {
    }

    public static void copy(ByteBuffer from, WritableByteChannel to) throws JournalNetworkException {
        try {
            if (to.write(from) < 1) {
                throw new JournalNetworkException("Write to closed channel");
            }
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(ByteBuffer from, WritableByteChannel to, long count) throws JournalNetworkException {
        int n;
        if (count < 1L || !from.hasRemaining()) {
            return 0;
        }
        if (count >= (long)from.remaining()) {
            int result = to.write(from);
            if (result < 1) {
                throw new JournalNetworkException("Write to closed channel");
            }
            return result;
        }
        int limit = from.limit();
        try {
            from.limit((int)((long)from.position() + count));
            int result = to.write(from);
            if (result < 1) {
                throw new JournalNetworkException("Write to closed channel");
            }
            n = result;
            from.limit(limit);
        }
        catch (Throwable throwable) {
            try {
                from.limit(limit);
                throw throwable;
            }
            catch (IOException e) {
                throw new JournalNetworkException(e);
            }
        }
        return n;
    }

    public static int copy(ReadableByteChannel from, ByteBuffer to) throws JournalNetworkException {
        try {
            int r;
            int result;
            for (int target = r = to.remaining(); target > 0; target -= result) {
                result = from.read(to);
                if (result != -1) continue;
                throw new JournalDisconnectedChannelException();
            }
            return r;
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
    }

    public static int copy(ReadableByteChannel from, ByteBuffer to, long count) throws JournalNetworkException {
        return count < (long)to.remaining() ? ByteBuffers.copy0(from, to, count) : ByteBuffers.copy(from, to);
    }

    public static void copy(ByteBuffer from, ByteBuffer to) {
        int y;
        int d;
        int x = from.remaining();
        int n = d = x < (y = to.remaining()) ? x : y;
        if (from instanceof DirectBuffer && to instanceof DirectBuffer) {
            Unsafe.getUnsafe().copyMemory(ByteBuffers.getAddress(from) + (long)from.position(), ByteBuffers.getAddress(to) + (long)to.position(), d);
            from.position(from.position() + d);
            to.position(to.position() + d);
        } else {
            to.put(from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyGreedyNonBlocking(ReadableByteChannel channel, ByteBuffer to, int retryCount) throws IOException {
        try {
            int r;
            int result;
            int retriesRemaining = retryCount;
            for (int target = r = to.remaining(); target > 0; target -= result) {
                result = channel.read(to);
                if (result == -1) {
                    throw DisconnectedChannelException.INSTANCE;
                }
                if (result != 0 || --retriesRemaining >= 0) continue;
                if (target == r) {
                    throw SlowReadableChannelException.INSTANCE;
                }
                break;
            }
        }
        finally {
            to.flip();
        }
    }

    public static void copyNonBlocking(ByteBuffer from, WritableByteChannel channel, int retryCount) throws DisconnectedChannelException, SlowWritableChannelException {
        int target = from.remaining();
        int retriesRemaining = retryCount;
        block6: while (target > 0) {
            int result;
            try {
                result = channel.write(from);
            }
            catch (SlowWritableChannelException e) {
                throw e;
            }
            catch (IOException e) {
                throw DisconnectedChannelException.INSTANCE;
            }
            if (result > 0) {
                target -= result;
                continue;
            }
            switch (result) {
                case 0: {
                    if (--retriesRemaining >= 0) continue block6;
                    throw SlowWritableChannelException.INSTANCE;
                }
            }
            throw DisconnectedChannelException.INSTANCE;
        }
    }

    public static void copyNonBlocking(NetworkChannel channel, ByteBuffer to, int retryCount) throws DisconnectedChannelException, SlowReadableChannelException, EndOfChannelException {
        int r;
        int target = r = to.remaining();
        int retriesRemaining = retryCount;
        block6: while (target > 0) {
            int result;
            try {
                result = channel.read(to);
            }
            catch (IOException e) {
                throw DisconnectedChannelException.INSTANCE;
            }
            if (result > 0) {
                target -= result;
                continue;
            }
            switch (result) {
                case 0: {
                    if (target < r) break block6;
                    if (--retriesRemaining >= 0) continue block6;
                    throw SlowReadableChannelException.INSTANCE;
                }
                case -1: {
                    throw EndOfChannelException.INSTANCE;
                }
                default: {
                    throw DisconnectedChannelException.INSTANCE;
                }
            }
        }
    }

    public static void dump(ByteBuffer b) {
        int p = b.position();
        while (b.hasRemaining()) {
            System.out.print((char)b.get());
        }
        b.position(p);
    }

    public static long getAddress(ByteBuffer buffer) {
        return ((DirectBuffer)((Object)buffer)).address();
    }

    public static int getBitHint(int recSize, int recCount) {
        long target = (long)recSize * (long)recCount;
        long minDeviation = Long.MAX_VALUE;
        int resultBits = 0;
        for (int i = 0; i < multipliers.length; ++i) {
            int m = multipliers[i];
            int bits = Math.min(30, Numbers.msb(recSize * recCount / m));
            long actual = (1 << bits) * m;
            if (target / actual > (long)multipliers[multipliers.length - 1]) {
                return bits;
            }
            long deviation = actual <= target ? 100L + target % actual * 100L / (long)(1 << bits) : actual * 100L / target;
            if (deviation >= minDeviation) continue;
            minDeviation = deviation;
            resultBits = bits;
        }
        return resultBits;
    }

    public static long getMaxMappedBufferSize(long channelSize) {
        long max = Os.getSystemMemory() / 4L;
        max = max > Integer.MAX_VALUE ? Integer.MAX_VALUE : max;
        return channelSize > max ? max : channelSize;
    }

    public static boolean isDirect(ByteBuffer buf) {
        return buf instanceof DirectBuffer;
    }

    public static void putStr(ByteBuffer buffer, CharSequence value) {
        int p = buffer.position();
        for (int i = 0; i < value.length(); ++i) {
            buffer.putChar(p, value.charAt(i));
            p += 2;
        }
        buffer.position(p);
    }

    public static void putStringDW(ByteBuffer buffer, String value) {
        if (value == null) {
            buffer.putInt(0);
        } else {
            buffer.putInt(value.length());
            ByteBuffers.putStr(buffer, value);
        }
    }

    public static void putStringW(ByteBuffer buffer, String value) {
        if (value == null) {
            buffer.putChar('\u0000');
        } else {
            buffer.putChar((char)value.length());
            ByteBuffers.putStr(buffer, value);
        }
    }

    public static <T extends ByteBuffer> T release(T buffer) {
        if (buffer instanceof DirectBuffer) {
            ((DirectBuffer)((Object)buffer)).cleaner().clean();
            return null;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copy0(ReadableByteChannel from, ByteBuffer to, long count) throws JournalNetworkException {
        int result;
        int limit = to.limit();
        try {
            to.limit((int)((long)to.position() + count));
            try {
                result = from.read(to);
            }
            catch (IOException e) {
                throw new JournalNetworkException(e);
            }
            if (result == -1) {
                throw new JournalDisconnectedChannelException();
            }
        }
        finally {
            to.limit(limit);
        }
        return result;
    }
}

