/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import java.util.Arrays;

public class CharSequenceHashSet
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final double loadFactor;
    private final ObjList<CharSequence> list;
    private CharSequence[] keys;
    private int free;
    private int capacity;
    private int mask;
    private boolean hasNull = false;

    public CharSequenceHashSet() {
        this(16);
    }

    public CharSequenceHashSet(CharSequenceHashSet that) {
        this(that.capacity, that.loadFactor, 0.3);
        this.addAll(that);
    }

    private CharSequenceHashSet(int initialCapacity) {
        this(initialCapacity, 0.4, 0.3);
    }

    private CharSequenceHashSet(int initialCapacity, double loadFactor, double hashFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        if (hashFactor <= 0.0 || hashFactor >= 1.0) {
            throw new IllegalArgumentException("0 < hashFactor < 1");
        }
        initialCapacity = (int)((double)initialCapacity * (1.0 + hashFactor));
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        this.loadFactor = loadFactor;
        this.keys = new CharSequence[capacity < 16 ? 16 : Numbers.ceilPow2(capacity)];
        this.mask = this.keys.length - 1;
        this.free = this.capacity = initialCapacity;
        this.list = new ObjList(this.free);
        this.clear();
    }

    public boolean add(CharSequence key) {
        return this.add0(key);
    }

    public boolean add0(CharSequence key) {
        if (key == null) {
            return this.addNull();
        }
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        String s = key.toString();
        Unsafe.arrayPut(this.keys, index, s);
        this.list.add(s);
        if (--this.free < 1) {
            this.resize();
        }
        return true;
    }

    public final void addAll(CharSequenceHashSet that) {
        int k = that.size();
        for (int i = 0; i < k; ++i) {
            this.add(that.get(i));
        }
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, null);
        this.list.clear();
        this.hasNull = false;
    }

    public boolean contains(CharSequence key) {
        if (key == null) {
            return this.hasNull;
        }
        return this.keyIndex(key) < 0;
    }

    public CharSequence get(int index) {
        return this.list.getQuick(index);
    }

    public CharSequence getLast() {
        return this.list.getLast();
    }

    public int remove(CharSequence key) {
        if (key == null) {
            return this.removeNull();
        }
        int index = this.keyIndex(key);
        if (index < 0) {
            int result = this.list.remove(Unsafe.arrayGet(this.keys, -index - 1));
            Unsafe.arrayPut(this.keys, -index - 1, null);
            ++this.free;
            this.rehash();
            return result;
        }
        return -1;
    }

    public int size() {
        return this.capacity - this.free;
    }

    public String toString() {
        return this.list.toString();
    }

    private boolean addNull() {
        if (this.hasNull) {
            return false;
        }
        --this.free;
        this.hasNull = true;
        this.list.add(null);
        return true;
    }

    private boolean eq(int index, CharSequence key) {
        return key == Unsafe.arrayGet(this.keys, index) || Chars.equals(key, Unsafe.arrayGet(this.keys, index));
    }

    private int keyIndex(CharSequence key) {
        int index = Chars.hashCode(key) & this.mask;
        if (Unsafe.arrayGet(this.keys, index) == null) {
            return index;
        }
        if (this.eq(index, key)) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    private int probe(CharSequence key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != null) continue;
            return index;
        } while (!this.eq(index, key));
        return -index - 1;
    }

    private void rehash() {
        Arrays.fill(this.keys, null);
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            CharSequence key = this.list.getQuick(i);
            Unsafe.arrayPut(this.keys, this.keyIndex(key), key);
        }
    }

    private int removeNull() {
        if (this.hasNull) {
            this.hasNull = false;
            int index = this.list.remove(null);
            ++this.free;
            return index;
        }
        return -1;
    }

    private void resize() {
        int newCapacity = this.keys.length << 1;
        this.mask = newCapacity - 1;
        int oldCapacity = this.capacity;
        this.capacity = (int)((double)newCapacity * this.loadFactor);
        this.free = this.capacity - oldCapacity;
        this.keys = new CharSequence[newCapacity];
        this.rehash();
    }
}

