/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.str.NullCharSequence;
import java.util.Arrays;

public class CharSequenceIntHashMap
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final int NO_ENTRY_VALUE = -1;
    private static final CharSequence noEntryKey = NullCharSequence.INSTANCE;
    private final int noEntryValue;
    private final double loadFactor;
    private CharSequence[] keys;
    private int[] values;
    private int free;
    private int capacity;
    private int mask;

    public CharSequenceIntHashMap() {
        this(8);
    }

    public CharSequenceIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    public CharSequenceIntHashMap(int initialCapacity, double loadFactor, int noEntryValue) {
        this.noEntryValue = noEntryValue;
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        capacity = capacity < 16 ? 16 : Numbers.ceilPow2(capacity);
        this.loadFactor = loadFactor;
        this.keys = new CharSequence[capacity];
        this.values = new int[capacity];
        this.free = this.capacity = initialCapacity;
        this.mask = capacity - 1;
        this.clear();
    }

    @Override
    public final void clear() {
        Arrays.fill(this.keys, noEntryKey);
        Arrays.fill(this.values, this.noEntryValue);
        this.free = this.capacity;
    }

    public int get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public void increment(CharSequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            Unsafe.arrayPut(this.values, -index - 1, Unsafe.arrayGet(this.values, -index - 1) + 1);
        } else {
            this.putAt0(index, key, 0);
        }
    }

    public CharSequence keyAt(int index) {
        return index < 0 ? Unsafe.arrayGet(this.keys, -index - 1) : null;
    }

    public int keyIndex(CharSequence key) {
        int index = Chars.hashCode(key) & this.mask;
        if (Unsafe.arrayGet(this.keys, index) == noEntryKey) {
            return index;
        }
        if (Chars.equals(key, Unsafe.arrayGet(this.keys, index))) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public boolean put(CharSequence key, int value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, CharSequence key, int value) {
        if (index < 0) {
            Unsafe.arrayPut(this.values, -index - 1, value);
            return false;
        }
        this.putAt0(index, key, value);
        return true;
    }

    public void putIfAbsent(CharSequence key, int value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt0(index, key, value);
        }
    }

    public boolean remove(CharSequence key) {
        return this.removeAt(this.keyIndex(key));
    }

    public boolean removeAt(int index) {
        if (index < 0) {
            Unsafe.arrayPut(this.values, -index - 1, this.noEntryValue);
            ++this.free;
            return true;
        }
        return false;
    }

    public int size() {
        return this.capacity - this.free;
    }

    public int valueAt(int index) {
        return index < 0 ? Unsafe.arrayGet(this.values, -index - 1) : this.noEntryValue;
    }

    private int probe(CharSequence key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != noEntryKey) continue;
            return index;
        } while (!Chars.equals(key, Unsafe.arrayGet(this.keys, index)));
        return -index - 1;
    }

    private void putAt0(int index, CharSequence key, int value) {
        Unsafe.arrayPut(this.keys, index, key);
        Unsafe.arrayPut(this.values, index, value);
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        int newCapacity = this.values.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        int[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[newCapacity];
        this.values = new int[newCapacity];
        Arrays.fill(this.keys, noEntryKey);
        Arrays.fill(this.values, this.noEntryValue);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldKeys, i) == noEntryKey) continue;
            this.put(Unsafe.arrayGet(oldKeys, i), Unsafe.arrayGet(oldValues, i));
        }
    }
}

