/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.str.NullCharSequence;
import java.util.Arrays;
import java.util.Comparator;

public class CharSequenceObjHashMap<V>
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final CharSequence noEntryValue = NullCharSequence.INSTANCE;
    private final double loadFactor;
    private final ObjList<CharSequence> list;
    private CharSequence[] keys;
    private V[] values;
    private int free;
    private int capacity;
    private int mask;

    public CharSequenceObjHashMap() {
        this(8);
    }

    private CharSequenceObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private CharSequenceObjHashMap(int initialCapacity, double loadFactor) {
        this.list = new ObjList(initialCapacity);
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        capacity = capacity < 16 ? 16 : Numbers.ceilPow2(capacity);
        this.loadFactor = loadFactor;
        this.keys = new CharSequence[capacity];
        this.values = new Object[capacity];
        this.free = this.capacity = initialCapacity;
        this.mask = capacity - 1;
        this.clear();
    }

    @Override
    public final void clear() {
        Arrays.fill(this.keys, noEntryValue);
        this.free = this.capacity;
        this.list.clear();
    }

    public V get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public int keyIndex(CharSequence key) {
        int index = Chars.hashCode(key) & this.mask;
        if (Unsafe.arrayGet(this.keys, index) == noEntryValue) {
            return index;
        }
        if (Chars.equals(key, Unsafe.arrayGet(this.keys, index))) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public ObjList<CharSequence> keys() {
        return this.list;
    }

    public boolean put(CharSequence key, V value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public void remove(CharSequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            Unsafe.arrayPut(this.keys, -index - 1, noEntryValue);
            Unsafe.arrayPut(this.values, -index - 1, null);
            this.list.remove(key);
            ++this.free;
        }
    }

    public int size() {
        return this.list.size();
    }

    public void sortKeys(Comparator<CharSequence> comparator) {
        this.list.sort(comparator);
    }

    public boolean putAt(int index, CharSequence key, V value) {
        if (this.putAt0(index, key, value)) {
            this.list.add(key);
            return true;
        }
        return false;
    }

    public V valueQuick(int index) {
        return this.get(this.list.getQuick(index));
    }

    private int probe(CharSequence key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != noEntryValue) continue;
            return index;
        } while (!Chars.equals(key, Unsafe.arrayGet(this.keys, index)));
        return -index - 1;
    }

    public V valueAt(int index) {
        return index < 0 ? (V)Unsafe.arrayGet(this.values, -index - 1) : null;
    }

    private boolean putAt0(int index, CharSequence key, V value) {
        if (index < 0) {
            Unsafe.arrayPut(this.values, -index - 1, value);
            return false;
        }
        Unsafe.arrayPut(this.keys, index, key);
        Unsafe.arrayPut(this.values, index, value);
        if (--this.free == 0) {
            this.rehash();
        }
        return true;
    }

    private void rehash() {
        int newCapacity = this.values.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        V[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[newCapacity];
        this.values = new Object[newCapacity];
        Arrays.fill(this.keys, noEntryValue);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldKeys, i) == noEntryValue) continue;
            this.putAt0(this.keyIndex(Unsafe.arrayGet(oldKeys, i)), Unsafe.arrayGet(oldKeys, i), Unsafe.arrayGet(oldValues, i));
        }
    }
}

