/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.Misc;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.str.ByteSequence;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectBytes;
import com.questdb.std.str.Path;
import com.questdb.std.str.StringSink;

public final class Chars {
    private static final ThreadLocal<char[]> builder = new ThreadLocal();

    private Chars() {
    }

    public static int compare(CharSequence l, CharSequence r) {
        int n;
        if (l == r) {
            return 0;
        }
        if (l == null) {
            return -1;
        }
        if (r == null) {
            return 1;
        }
        int ll = l.length();
        int rl = r.length();
        int n2 = n = ll < rl ? ll : rl;
        for (int i = 0; i < n; ++i) {
            int k = l.charAt(i) - r.charAt(i);
            if (k == 0) continue;
            return k;
        }
        return Integer.compare(ll, rl);
    }

    public static boolean contains(CharSequence _this, CharSequence that) {
        int m = that.length();
        if (m == 0) {
            return false;
        }
        int n = _this.length();
        for (int i = 0; i < n; ++i) {
            if (_this.charAt(i) != that.charAt(0)) continue;
            if (n - i < m) {
                return false;
            }
            boolean found = true;
            for (int k = 1; k < m && k + i < n; ++k) {
                if (_this.charAt(i + k) == that.charAt(k)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(CharSequence cs, CharSequence ends) {
        if (ends == null || cs == null) {
            return false;
        }
        int l = ends.length();
        if (l == 0) {
            return false;
        }
        int csl = cs.length();
        return csl != 0 && csl >= l && Chars.equals(ends, cs, csl - l, csl);
    }

    public static boolean equals(CharSequence l, CharSequence r) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i) == r.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence l, CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence l, int lLo, int lHi, CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i + lLo) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence l, char r) {
        return l.length() == 1 && l.charAt(0) == r;
    }

    public static boolean equalsIgnoreCase(CharSequence l, CharSequence r) {
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Character.toLowerCase(l.charAt(i)) == r.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(CharSequence l, int llo, int lhi, CharSequence r, int rlo, int rhi) {
        int lp = llo;
        int rp = rlo;
        while (lp < lhi && rp < rhi) {
            if (Character.toLowerCase(l.charAt(lp++)) == r.charAt(rp++)) continue;
            return false;
        }
        return lp == lhi && rp == rhi;
    }

    public static boolean equalsNc(CharSequence l, CharSequence r) {
        return r != null && Chars.equals(l, r);
    }

    public static String getFileName(CharSequence path) {
        int pos = -1;
        int k = path.length();
        for (int i = 0; i < k; ++i) {
            char c = path.charAt(i);
            if (c != '\\' && c != '/') continue;
            pos = i;
        }
        int l = path.length() - pos - 1;
        if (l == 0) {
            throw new JournalRuntimeException("Invalid path: %s", path);
        }
        char[] buf = builder.get();
        if (buf == null || buf.length < l) {
            buf = new char[l];
            builder.set(buf);
        }
        int p = 0;
        int k2 = path.length();
        for (int i = pos + 1; i < k2; ++i) {
            buf[p++] = path.charAt(i);
        }
        return new String(buf, 0, l);
    }

    public static int hashCode(CharSequence value) {
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + value.charAt(p);
        }
        return h;
    }

    public static int hashCode(DirectBytes value) {
        int len = value.byteLength();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        long address = value.address();
        int n = len / 2;
        for (int p = 0; p < n; ++p) {
            h = 31 * h + Unsafe.getUnsafe().getChar(address + (long)(p << 1));
        }
        return h;
    }

    public static int indexOf(CharSequence s, char c) {
        return Chars.indexOf(s, 0, c);
    }

    public static int indexOf(CharSequence s, int lo, char c) {
        int n = s.length();
        for (int i = lo; i < n; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence s, char c) {
        for (int i = s.length() - 1; i > -1; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static void putCharsOnly(long address, CharSequence value) {
        Chars.strcpyw(value, value.length(), address);
    }

    public static ObjList<Path> splitLpsz(CharSequence args) {
        ObjList<Path> paths = new ObjList<Path>();
        int n = args.length();
        int lastLen = 0;
        int lastIndex = 0;
        boolean inQuote = false;
        block4: for (int i = 0; i < n; ++i) {
            char b = args.charAt(i);
            switch (b) {
                case ' ': {
                    if (lastLen <= 0) continue block4;
                    if (inQuote) {
                        ++lastLen;
                        continue block4;
                    }
                    paths.add(new Path().of(args, lastIndex, lastLen).$());
                    lastLen = 0;
                    continue block4;
                }
                case '\"': {
                    inQuote = !inQuote;
                    continue block4;
                }
                default: {
                    if (lastLen == 0) {
                        lastIndex = i;
                    }
                    ++lastLen;
                }
            }
        }
        if (lastLen > 0) {
            paths.add(new Path().of(args, lastIndex, lastLen).$());
        }
        return paths;
    }

    public static boolean startsWith(CharSequence _this, CharSequence that) {
        int len = that.length();
        if (_this.length() < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (_this.charAt(i) == that.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence _this, char c) {
        return _this.length() > 0 && _this.charAt(0) == c;
    }

    public static void strcpy(CharSequence value, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(address + (long)i, (byte)value.charAt(i));
        }
    }

    public static void strcpy(ByteSequence value, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(address + (long)i, value.byteAt(i));
        }
    }

    public static int strcpyw(CharSequence value, long address) {
        int len = value.length();
        Unsafe.getUnsafe().putInt(address, len);
        Chars.strcpyw(value, len, address + 4L);
        return (len << 1) + 4;
    }

    public static void strcpyw(CharSequence value, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(address + (long)(i << 1), value.charAt(i));
        }
    }

    public static String stripQuotes(String s) {
        int l;
        if (s == null || (l = s.length()) == 0) {
            return s;
        }
        switch (s.charAt(0)) {
            case '\"': 
            case '\'': 
            case '`': {
                return s.substring(1, l - 1);
            }
        }
        return s;
    }

    public static String toString(CharSequence s) {
        return s == null ? null : s.toString();
    }

    public static String toUtf8String(ByteSequence in) {
        if (in == null) {
            return null;
        }
        StringSink b = Misc.getThreadLocalBuilder();
        Chars.utf8Decode(in, b);
        return ((Object)b).toString();
    }

    public static void utf8Decode(ByteSequence in, CharSink sink) {
        int index = 0;
        int len = in.length();
        while (index < len) {
            byte b = in.byteAt(index);
            if (b < 0) {
                index += Chars.utf8DecodeMultiByte(in, b, index, len, sink);
                continue;
            }
            sink.put((char)b);
            ++index;
        }
    }

    public static int utf8DecodeMultiByte(ByteSequence in, int b, int index, int len, CharSink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Chars.utf8Decode2Bytes(in, b, index, len, sink);
        }
        if (b >> 4 == -2) {
            return Chars.utf8Decode3Bytes(in, b, index, len, sink);
        }
        return Chars.utf8Decode4Bytes(in, b, index, len, sink);
    }

    private static int utf8error() {
        return -1;
    }

    private static int utf8Decode4Bytes(ByteSequence in, int b, int index, int len, CharSink sink) {
        if (b >> 3 != -2) {
            return Chars.utf8error();
        }
        if (len - index > 3) {
            byte b2 = in.byteAt(index + 1);
            byte b3 = in.byteAt(index + 2);
            byte b4 = in.byteAt(index + 3);
            int codePoint = b << 18 ^ b2 << 12 ^ b3 << 6 ^ b4 ^ 0x381F80;
            if (!Chars.isMalformed4(b2, b3, b4) && Character.isSupplementaryCodePoint(codePoint)) {
                sink.put(Character.highSurrogate(codePoint));
                sink.put(Character.lowSurrogate(codePoint));
                return 4;
            }
        }
        return Chars.utf8error();
    }

    private static int utf8Decode3Bytes(ByteSequence in, int b, int index, int len, CharSink sink) {
        byte b3;
        if (len - index < 3) {
            return Chars.utf8error();
        }
        byte b2 = in.byteAt(index + 1);
        if (Chars.isMalformed3(b, b2, b3 = in.byteAt(index + 2))) {
            return Chars.utf8error();
        }
        char c = (char)(b << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80);
        if (Character.isSurrogate(c)) {
            return Chars.utf8error();
        }
        sink.put(c);
        return 3;
    }

    private static int utf8Decode2Bytes(ByteSequence in, int b, int index, int len, CharSink sink) {
        if (len - index < 2) {
            return Chars.utf8error();
        }
        byte b2 = in.byteAt(index + 1);
        if (Chars.isNotContinuation(b2)) {
            return Chars.utf8error();
        }
        sink.put((char)(b << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    private static boolean isNotContinuation(int b) {
        return (b & 0xC0) != 128;
    }

    private static boolean isMalformed3(int b1, int b2, int b3) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
    }

    private static boolean isMalformed4(int b2, int b3, int b4) {
        return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
    }
}

