/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.Unsafe;
import com.questdb.std.str.StringSink;
import java.io.Closeable;

public class DirectLongList
implements Mutable,
Closeable {
    public static final int CACHE_LINE_SIZE = 64;
    private final int pow2;
    private final int onePow2;
    long pos;
    long start;
    long limit;
    private long address;
    private long capacity;

    public DirectLongList(long capacity) {
        this.pow2 = 3;
        this.capacity = (capacity << 3) + 64L;
        this.address = Unsafe.malloc(this.capacity);
        this.start = this.pos = this.address + (this.address & 0x3FL);
        this.limit = this.pos + (capacity - 1L << 3);
        this.onePow2 = 8;
    }

    public void add(long x) {
        this.ensureCapacity();
        Unsafe.getUnsafe().putLong(this.pos, x);
        this.pos += 8L;
    }

    public final void add(DirectLongList that) {
        int count = (int)(that.pos - that.start);
        if (this.limit - this.pos < (long)count) {
            this.extend((int)(this.limit - this.start + (long)count) >> 1);
        }
        Unsafe.getUnsafe().copyMemory(that.start, this.pos, count);
        this.pos += (long)count;
    }

    public int binarySearch(long v) {
        int low = 0;
        int high = (int)(this.pos - this.start >> 3) - 1;
        while (low <= high) {
            if (high - low < 65) {
                return this.scanSearch(v);
            }
            int mid = low + high >>> 1;
            long midVal = Unsafe.getUnsafe().getLong(this.start + (long)(mid << 3));
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public void clear() {
        this.clear(0L);
    }

    public void clear(long b) {
        this.pos = this.start;
        this.zero(b);
    }

    @Override
    public void close() {
        if (this.address != 0L) {
            Unsafe.free(this.address, this.capacity);
            this.address = 0L;
        }
    }

    public long get(long p) {
        return Unsafe.getUnsafe().getLong(this.start + (p << 3));
    }

    public int scanSearch(long v) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            long f = this.get(i);
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1);
        }
        return -(sz + 1);
    }

    public void set(long p, long v) {
        assert (p >= 0L && p <= this.limit - this.start >> 3);
        Unsafe.getUnsafe().putLong(this.start + (p << 3), v);
    }

    public void setCapacity(long capacity) {
        if (capacity << this.pow2 > this.limit - this.start) {
            this.extend(capacity);
        }
    }

    public void setPos(long p) {
        this.pos = this.start + (p << this.pow2);
    }

    public int size() {
        return (int)(this.pos - this.start >> this.pow2);
    }

    public DirectLongList subset(int lo, int hi) {
        DirectLongList that = new DirectLongList(hi - lo);
        Unsafe.getUnsafe().copyMemory(this.start + (long)(lo << 3), that.start, hi - lo << 3);
        that.pos += (long)(hi - lo << 3);
        return that;
    }

    public String toString() {
        StringSink sb = Misc.getThreadLocalBuilder();
        sb.put('{');
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.put(',').put(' ');
            }
            sb.put(this.get(i));
        }
        sb.put('}');
        return ((Object)sb).toString();
    }

    public void zero(long v) {
        Unsafe.getUnsafe().setMemory(this.start, this.limit - this.start + (long)this.onePow2, (byte)v);
    }

    void ensureCapacity() {
        if (this.pos > this.limit) {
            this.extend((int)(this.limit - this.start + (long)this.onePow2 >> this.pow2 - 1));
        }
    }

    private void extend(long capacity) {
        this.capacity = (capacity << this.pow2) + 64L;
        long address = Unsafe.malloc(this.capacity);
        long start = address + (address & 0x3FL);
        Unsafe.getUnsafe().copyMemory(this.start, start, this.limit + (long)this.onePow2 - this.start);
        if (this.address != 0L) {
            Unsafe.free(this.address, this.capacity);
        }
        this.pos = this.pos - this.start + start;
        this.limit = start + (capacity - 1L << this.pow2);
        this.address = address;
        this.start = start;
    }
}

