/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.common.JournalRuntimeException;
import com.questdb.std.Chars;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicLong;

public final class Files {
    public static final Charset UTF_8;
    public static final long PAGE_SIZE;
    public static final int DT_UNKNOWN = 0;
    public static final int DT_FIFO = 1;
    public static final int DT_CHR = 2;
    public static final int DT_DIR = 4;
    public static final int DT_BLK = 6;
    public static final int DT_REG = 8;
    public static final int DT_LNK = 10;
    public static final int DT_SOCK = 12;
    public static final int DT_WHT = 14;
    public static final int MAP_RO = 1;
    public static final int MAP_RW = 2;
    public static final char SEPARATOR;
    static final AtomicLong OPEN_FILE_COUNT;

    private Files() {
    }

    public static native long append(long var0, long var2, long var4);

    public static int close(long fd) {
        int res = Files.close0(fd);
        if (res == 0) {
            OPEN_FILE_COUNT.decrementAndGet();
        }
        return res;
    }

    public static long copy(long fdFrom, long fdTo, long bufPtr, int bufSize) {
        long l;
        long total = 0L;
        while ((l = Files.sequentialRead(fdFrom, bufPtr, bufSize)) > 0L) {
            Files.append(fdTo, bufPtr, (int)l);
            total += l;
        }
        return total;
    }

    public static boolean delete(File file) {
        try {
            Files.deleteOrException(file);
            return true;
        }
        catch (JournalException e) {
            return false;
        }
    }

    public static void deleteOrException(File file) throws JournalException {
        if (!file.exists()) {
            return;
        }
        Files.deleteDirContentsOrException(file);
        boolean deleted = false;
        for (int retryCount = 3; retryCount > 0 && !(deleted = file.delete()); --retryCount) {
            Thread.yield();
        }
        if (!deleted) {
            throw new JournalException("Cannot delete file %s", file);
        }
    }

    public static native boolean exists(long var0);

    public static boolean exists(LPSZ lpsz) {
        return lpsz != null && Files.getLastModified(lpsz) != -1L;
    }

    public static native void findClose(long var0);

    public static long findFirst(LPSZ lpsz) {
        return Files.findFirst(lpsz.address());
    }

    public static native long findName(long var0);

    public static native int findNext(long var0);

    public static native int findType(long var0);

    public static long getLastModified(LPSZ lpsz) {
        return Files.getLastModified(lpsz.address());
    }

    public static long getOpenFileCount() {
        return OPEN_FILE_COUNT.get();
    }

    public static native long getStdOutFd();

    public static boolean isDots(CharSequence name) {
        return Chars.equals(name, '.') || Chars.equals(name, "..");
    }

    public static long length(LPSZ lpsz) {
        return Files.length0(lpsz.address());
    }

    public static native long length(long var0);

    public static native int lock(long var0);

    public static File makeTempDir() {
        File result;
        try {
            result = File.createTempFile("questdb", "");
            Files.deleteOrException(result);
            Files.mkDirsOrException(result);
        }
        catch (Exception e) {
            throw new JournalRuntimeException("Exception when creating temp dir", (Throwable)e, new Object[0]);
        }
        return result;
    }

    public static File makeTempFile() {
        try {
            return File.createTempFile("questdb", "");
        }
        catch (IOException e) {
            throw new JournalRuntimeException(e);
        }
    }

    public static void mkDirsOrException(File dir) {
        if (!dir.mkdirs()) {
            throw new JournalRuntimeException("Cannot create temp directory: %s", dir);
        }
    }

    public static int mkdir(LPSZ path, int mode) {
        return Files.mkdir(path.address(), mode);
    }

    public static int mkdirs(LPSZ path, int mode) {
        try (Path pp = new Path();){
            int n = path.length();
            for (int i = 0; i < n; ++i) {
                char c = path.charAt(i);
                if (c == File.separatorChar) {
                    int r;
                    if (i == 2 && Os.type == 3 && path.charAt(1) == ':') {
                        pp.put(c);
                        continue;
                    }
                    pp.$();
                    if (pp.length() > 0 && !Files.exists(pp) && (r = Files.mkdir(pp, mode)) != 0) {
                        int n2 = r;
                        return n2;
                    }
                    pp.chopZ();
                }
                pp.put(c);
            }
        }
        return 0;
    }

    public static long mmap(long fd, long len, long offset, int flags) {
        long address = Files.mmap0(fd, len, offset, flags);
        if (address != -1L) {
            Unsafe.MEM_USED.addAndGet(len);
        }
        return address;
    }

    public static void munmap(long address, long len) {
        if (address != 0L && Files.munmap0(address, len) != -1) {
            Unsafe.MEM_USED.addAndGet(-len);
        }
    }

    public static long openAppend(LPSZ lpsz) {
        long fd = Files.openAppend(lpsz.address());
        if (fd != -1L) {
            OPEN_FILE_COUNT.incrementAndGet();
        }
        return fd;
    }

    public static long openRO(LPSZ lpsz) {
        long fd = Files.openRO(lpsz.address());
        if (fd != -1L) {
            OPEN_FILE_COUNT.incrementAndGet();
        }
        return fd;
    }

    public static long openRW(LPSZ lpsz) {
        long fd = Files.openRW(lpsz.address());
        if (fd != -1L) {
            OPEN_FILE_COUNT.incrementAndGet();
        }
        return fd;
    }

    public static native long read(long var0, long var2, long var4, long var6);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readStringFromFile(File file) throws JournalException {
        try (FileInputStream fis = new FileInputStream(file);){
            int read;
            byte[] buffer = new byte[(int)fis.getChannel().size()];
            for (int totalRead = 0; totalRead < buffer.length && (read = fis.read(buffer, totalRead, buffer.length - totalRead)) > 0; totalRead += read) {
            }
            String string = new String(buffer, UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new JournalException("Cannot read from %s", (Throwable)e, file.getAbsolutePath());
        }
    }

    public static boolean remove(LPSZ lpsz) {
        return Files.remove(lpsz.address());
    }

    public static boolean rename(LPSZ oldName, LPSZ newName) {
        return Files.rename(oldName.address(), newName.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rmdir(Path path) {
        long p = Files.findFirst(path.address());
        int len = path.length();
        if (p > 0L) {
            try {
                block8: do {
                    long lpszName = Files.findName(p);
                    path.trimTo(len).concat(lpszName).$();
                    switch (Files.findType(p)) {
                        case 4: {
                            if (Files.strcmp(lpszName, "..") || Files.strcmp(lpszName, ".") || Files.rmdir(path)) continue block8;
                            boolean bl = false;
                            return bl;
                        }
                        default: {
                            if (Files.remove(path.address())) continue block8;
                            boolean bl = false;
                            return bl;
                        }
                    }
                } while (Files.findNext(p) > 0);
            }
            finally {
                Files.findClose(p);
            }
            return Files.rmdir(path.trimTo(len).$().address());
        }
        return false;
    }

    public static native long sequentialRead(long var0, long var2, int var4);

    public static boolean setLastModified(LPSZ lpsz, long millis) {
        return Files.setLastModified(lpsz.address(), millis);
    }

    public static boolean touch(LPSZ lpsz) {
        boolean result;
        long fd = Files.openRW(lpsz);
        boolean bl = result = fd > 0L;
        if (result) {
            Files.close(fd);
        }
        return result;
    }

    public static native boolean truncate(long var0, long var2);

    public static native long write(long var0, long var2, long var4, long var6);

    public static void writeStringToFile(File file, String s) throws JournalException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(s.getBytes(UTF_8));
        }
        catch (IOException e) {
            throw new JournalException("Cannot write to %s", (Throwable)e, file.getAbsolutePath());
        }
    }

    static native int close0(long var0);

    private static boolean strcmp(long lpsz, CharSequence s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte b = Unsafe.getUnsafe().getByte(lpsz + (long)i);
            if (b != 0 && b == (byte)s.charAt(i)) continue;
            return false;
        }
        return Unsafe.getUnsafe().getByte(lpsz + (long)len) == 0;
    }

    private static native int munmap0(long var0, long var2);

    private static native long mmap0(long var0, long var2, long var4, int var6);

    private static native long getPageSize();

    private static native boolean remove(long var0);

    private static native boolean rmdir(long var0);

    private static native long getLastModified(long var0);

    private static native long length0(long var0);

    private static native int mkdir(long var0, int var2);

    private static native long openRO(long var0);

    private static native long openRW(long var0);

    private static native long openAppend(long var0);

    private static native long findFirst(long var0);

    private static native boolean setLastModified(long var0, long var2);

    private static void deleteDirContentsOrException(File file) throws JournalException {
        if (!file.exists()) {
            return;
        }
        try {
            File[] files;
            if (Files.notSymlink(file) && (files = file.listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    Files.deleteOrException(files[i]);
                }
            }
        }
        catch (IOException e) {
            throw new JournalException("Cannot delete dir contents: %s", file, e);
        }
    }

    private static boolean notSymlink(File file) throws IOException {
        File fileInCanonicalDir;
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (File.separatorChar == '\\') {
            return true;
        }
        if (file.getParentFile() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    private static native boolean rename(long var0, long var2);

    static {
        OPEN_FILE_COUNT = new AtomicLong();
        Os.init();
        UTF_8 = Charset.forName("UTF-8");
        PAGE_SIZE = Files.getPageSize();
        SEPARATOR = (char)(Os.type == 3 ? 92 : 47);
    }
}

