/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Chars;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectBytes;

public final class Hash {
    private Hash() {
    }

    public static int boundedHash(CharSequence s, int max) {
        return s == null ? -1 : Chars.hashCode(s) & 0xFFFFFFF & max;
    }

    public static int boundedHash(DirectBytes s, int max) {
        return s == null ? -1 : Chars.hashCode(s) & 0xFFFFFFF & max;
    }

    public static int hashMem(long p, int len) {
        int hash = 0;
        long hi = p + (long)len;
        while (hi - p > 3L) {
            hash = (hash << 5) - hash + Unsafe.getUnsafe().getInt(p);
            p += 4L;
        }
        if (p < hi) {
            hash = (hash << 5) - hash + Unsafe.getUnsafe().getByte(p);
        }
        return hash < 0 ? -hash : hash;
    }
}

