/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.IntList;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import java.util.Arrays;

public class IntHashSet
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final int noEntryValue;
    private final double loadFactor;
    private final IntList list;
    private int[] keys;
    private int free;
    private int capacity;
    private int mask;

    public IntHashSet() {
        this(8);
    }

    public IntHashSet(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    public IntHashSet(int initialCapacity, double loadFactor, int noEntryValue) {
        this.noEntryValue = noEntryValue;
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.list = new IntList(initialCapacity);
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        this.loadFactor = loadFactor;
        this.keys = new int[capacity < 16 ? 16 : Numbers.ceilPow2(capacity)];
        this.mask = this.keys.length - 1;
        this.free = this.capacity = initialCapacity;
        this.clear();
    }

    public boolean add(int key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        Unsafe.arrayPut(this.keys, index, key);
        this.list.add(key);
        if (--this.free == 0) {
            this.rehash();
        }
        return true;
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, this.noEntryValue);
        this.list.clear();
    }

    public boolean contains(int key) {
        return this.keyIndex(key) < 0;
    }

    public int get(int index) {
        return this.list.getQuick(index);
    }

    public int keyIndex(int key) {
        int index = key & this.mask;
        if (Unsafe.arrayGet(this.keys, index) == this.noEntryValue) {
            return index;
        }
        if (Unsafe.arrayGet(this.keys, index) == key) {
            return -index - 1;
        }
        return this.probe0(key, index);
    }

    public void remove(int key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            assert (this.list.remove(key));
            Unsafe.arrayPut(this.keys, -index - 1, this.noEntryValue);
            ++this.free;
        }
    }

    public int size() {
        return this.capacity - this.free;
    }

    public String toString() {
        StringSink sink = new StringSink();
        this.toString(sink);
        return sink.toString();
    }

    private int probe0(int key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != this.noEntryValue) continue;
            return index;
        } while (key != Unsafe.arrayGet(this.keys, index));
        return -index - 1;
    }

    private void rehash() {
        int newCapacity = this.keys.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        int[] oldKeys = this.keys;
        this.keys = new int[newCapacity];
        Arrays.fill(this.keys, this.noEntryValue);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldKeys, i) == this.noEntryValue) continue;
            this.add(Unsafe.arrayGet(oldKeys, i));
        }
    }

    private void toString(CharSink sink) {
        sink.put('[');
        boolean needComma = false;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == this.noEntryValue) continue;
            if (needComma) {
                sink.put(',');
            }
            sink.put(this.keys[i]);
            if (needComma) continue;
            needComma = true;
        }
        sink.put(']');
    }
}

