/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.util.Arrays;

public class IntIntHashMap
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final int noEntryValue = -1;
    private final double loadFactor;
    private int[] values;
    private int[] keys;
    private int free;
    private int mask;

    public IntIntHashMap() {
        this(8);
    }

    private IntIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private IntIntHashMap(int initialCapacity, double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        capacity = capacity < 16 ? 16 : Numbers.ceilPow2(capacity);
        this.loadFactor = loadFactor;
        this.values = new int[capacity];
        this.keys = new int[capacity];
        this.free = initialCapacity;
        this.mask = capacity - 1;
        this.clear();
    }

    @Override
    public final void clear() {
        Arrays.fill(this.values, -1);
    }

    public int get(int key) {
        int index = key & this.mask;
        if (Unsafe.arrayGet(this.values, index) == -1 || Unsafe.arrayGet(this.keys, index) == key) {
            return Unsafe.arrayGet(this.values, index);
        }
        return this.probe(key, index);
    }

    public void put(int key, int value) {
        this.insertKey(key, value);
        if (this.free == 0) {
            this.rehash();
        }
    }

    private void insertKey(int key, int value) {
        int index = key & this.mask;
        if (Unsafe.arrayGet(this.values, index) == -1) {
            Unsafe.arrayPut(this.keys, index, key);
            Unsafe.arrayPut(this.values, index, value);
            --this.free;
            return;
        }
        if (Unsafe.arrayGet(this.keys, index) == key) {
            Unsafe.arrayPut(this.values, index, value);
            return;
        }
        this.probeInsert(key, index, value);
    }

    private int probe(int key, int index) {
        while (Unsafe.arrayGet(this.values, index = index + 1 & this.mask) != -1 && Unsafe.arrayGet(this.keys, index) != key) {
        }
        return Unsafe.arrayGet(this.values, index);
    }

    private void probeInsert(int key, int index, int value) {
        do {
            if (Unsafe.arrayGet(this.values, index = index + 1 & this.mask) != -1) continue;
            Unsafe.arrayPut(this.keys, index, key);
            Unsafe.arrayPut(this.values, index, value);
            --this.free;
            return;
        } while (key != Unsafe.arrayGet(this.keys, index));
        Unsafe.arrayPut(this.values, index, value);
    }

    private void rehash() {
        int newCapacity = this.values.length << 1;
        this.mask = newCapacity - 1;
        this.free = (int)((double)newCapacity * this.loadFactor);
        int[] oldValues = this.values;
        int[] oldKeys = this.keys;
        this.keys = new int[newCapacity];
        this.values = new int[newCapacity];
        Arrays.fill(this.values, -1);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldValues, i) == -1) continue;
            this.insertKey(Unsafe.arrayGet(oldKeys, i), Unsafe.arrayGet(oldValues, i));
        }
    }
}

