/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Unsafe;

public class IntLongPriorityQueue {
    private final long[] buf;
    private final int[] src;
    private int size;

    public IntLongPriorityQueue(int nSources) {
        this.buf = new long[nSources];
        this.src = new int[nSources];
        this.size = 0;
    }

    public void add(int index, long value) {
        int p = this.binSearch(value);
        if (p < this.size) {
            System.arraycopy(this.buf, p, this.buf, p + 1, this.size - p);
            System.arraycopy(this.src, p, this.src, p + 1, this.size - p);
        }
        Unsafe.arrayPut(this.src, p, index);
        Unsafe.arrayPut(this.buf, p, value);
        ++this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean hasNext() {
        return this.size > 0;
    }

    public int peekBottom() {
        return Unsafe.arrayGet(this.src, this.size - 1);
    }

    public long popAndReplace(int index, long value) {
        long v = Unsafe.arrayGet(this.buf, 0);
        int p = this.binSearch(value);
        if (p > 1) {
            System.arraycopy(this.buf, 1, this.buf, 0, --p);
            System.arraycopy(this.src, 1, this.src, 0, p);
            Unsafe.arrayPut(this.buf, p, value);
            Unsafe.arrayPut(this.src, p, index);
        } else {
            Unsafe.arrayPut(this.buf, 0, value);
            Unsafe.arrayPut(this.src, 0, index);
        }
        return v;
    }

    public int popIndex() {
        return Unsafe.arrayGet(this.src, 0);
    }

    public long popValue() {
        long v = Unsafe.arrayGet(this.buf, 0);
        if (--this.size > 0) {
            System.arraycopy(this.buf, 1, this.buf, 0, this.size);
            System.arraycopy(this.src, 1, this.src, 0, this.size);
        }
        return v;
    }

    private int binSearch(long v) {
        if (this.size < 65) {
            return this.scanSearch(v);
        }
        return this.binSearch0(v);
    }

    private int binSearch0(long v) {
        int low = 0;
        int high = this.size;
        while (low < high) {
            if (high - low < 65) {
                return this.scanSearch(v);
            }
            int mid = low + high - 1 >>> 1;
            long midVal = Unsafe.arrayGet(this.buf, mid);
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid;
                continue;
            }
            while (++mid < high && Unsafe.arrayGet(this.buf, mid) == v) {
            }
            return mid;
        }
        return low;
    }

    private int scanSearch(long v) {
        for (int i = 0; i < this.size; ++i) {
            if (Unsafe.arrayGet(this.buf, i) <= v) continue;
            return i;
        }
        return this.size;
    }
}

