/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.util.Arrays;

public class IntObjHashMap<V>
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final Object noEntryValue = new Object();
    private final double loadFactor;
    private V[] values;
    private int[] keys;
    private int free;
    private int capacity;
    private int mask;

    public IntObjHashMap() {
        this(8);
    }

    private IntObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private IntObjHashMap(int initialCapacity, double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        capacity = capacity < 16 ? 16 : Numbers.ceilPow2(capacity);
        this.loadFactor = loadFactor;
        this.values = new Object[capacity];
        this.keys = new int[capacity];
        this.free = this.capacity = initialCapacity;
        this.mask = capacity - 1;
        this.clear();
    }

    @Override
    public final void clear() {
        Arrays.fill(this.values, noEntryValue);
    }

    public V get(int key) {
        return this.keyAt(this.keyIndex(key));
    }

    public int keyIndex(int key) {
        int index = key & this.mask;
        if (Unsafe.arrayGet(this.values, index) == noEntryValue) {
            return index;
        }
        if (Unsafe.arrayGet(this.keys, index) == key) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public void put(int key, V value) {
        this.putAt(this.keyIndex(key), key, value);
    }

    public int size() {
        return this.capacity - this.free;
    }

    private V keyAt(int index) {
        return index < 0 ? (V)Unsafe.arrayGet(this.values, -index - 1) : null;
    }

    private int probe(int key, int index) {
        do {
            if (Unsafe.arrayGet(this.values, index = index + 1 & this.mask) != noEntryValue) continue;
            return index;
        } while (key != Unsafe.arrayGet(this.keys, index));
        return -index - 1;
    }

    private void putAt(int index, int key, V value) {
        if (index < 0) {
            Unsafe.arrayPut(this.values, -index - 1, value);
        } else {
            Unsafe.arrayPut(this.keys, index, key);
            Unsafe.arrayPut(this.values, index, value);
            if (--this.free == 0) {
                this.rehash();
            }
        }
    }

    private void rehash() {
        int newCapacity = this.values.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        V[] oldValues = this.values;
        int[] oldKeys = this.keys;
        this.keys = new int[newCapacity];
        this.values = new Object[newCapacity];
        Arrays.fill(this.values, 0, this.values.length, noEntryValue);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldValues, i) == noEntryValue) continue;
            this.put(Unsafe.arrayGet(oldKeys, i), Unsafe.arrayGet(oldValues, i));
        }
    }
}

