/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.util.Arrays;

public class IntStack
implements Mutable {
    private static final int noEntryValue = -1;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private int[] elements;
    private int head;
    private int tail;
    private int mask;

    public IntStack() {
        this.allocateElements(16);
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            this.tail = 0;
            this.head = 0;
            Arrays.fill(this.elements, -1);
        }
    }

    public boolean notEmpty() {
        return this.head != this.tail;
    }

    public int peek() {
        return Unsafe.arrayGet(this.elements, this.head);
    }

    public int pop() {
        int h = this.head;
        int result = Unsafe.arrayGet(this.elements, h);
        if (result == -1) {
            return -1;
        }
        Unsafe.arrayPut(this.elements, h, -1);
        this.head = h + 1 & this.mask;
        return result;
    }

    public void push(int e) {
        this.head = this.head - 1 & this.mask;
        Unsafe.arrayPut(this.elements, this.head, e);
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public int size() {
        return this.tail - this.head & this.mask;
    }

    public void update(int e) {
        this.elements[this.head] = e;
    }

    private void allocateElements(int capacity) {
        capacity = capacity < 8 ? 8 : Numbers.ceilPow2(capacity);
        this.elements = new int[capacity];
        this.mask = capacity - 1;
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Stack is too big");
        }
        int[] a = new int[newCapacity];
        System.arraycopy(this.elements, p, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, p);
        this.elements = a;
        this.head = 0;
        this.tail = n;
        this.mask = newCapacity - 1;
    }
}

