/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Chars;
import com.questdb.std.ImmutableIterator;
import com.questdb.std.IntObjHashMap;
import com.questdb.std.str.AbstractCharSequence;
import com.questdb.std.str.ByteSequence;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Lexer
implements ImmutableIterator<CharSequence> {
    public static final LenComparator COMPARATOR = new LenComparator();
    private static final CharSequenceHashSet whitespace = new CharSequenceHashSet();
    private final IntObjHashMap<List<CharSequence>> symbols = new IntObjHashMap();
    private final CharSequence floatingSequence = new FloatingSequence();
    private final CharSequence floatingByteSequence = new FloatingByteSequence();
    private CharSequence next = null;
    private int _lo;
    private int _hi;
    private int _pos;
    private int _len;
    private CharSequence content;
    private CharSequence unparsed;
    private CharSequence last;
    private CharSequence flyweightSequence;

    public Lexer() {
        int n = whitespace.size();
        for (int i = 0; i < n; ++i) {
            this.defineSymbol(whitespace.get(i).toString());
        }
    }

    public final void defineSymbol(String token) {
        char c0 = token.charAt(0);
        List<CharSequence> l = this.symbols.get(c0);
        if (l == null) {
            l = new ArrayList<CharSequence>();
            this.symbols.put(c0, l);
        }
        l.add(token);
        l.sort(COMPARATOR);
    }

    public CharSequence getContent() {
        return this.content;
    }

    public void setContent(CharSequence cs) {
        this.setContent(cs, 0, cs == null ? 0 : cs.length());
    }

    @Override
    public boolean hasNext() {
        boolean n;
        boolean bl = n = this.next != null || this.unparsed != null || this.content != null && this._pos < this._len;
        if (!n && this.last != null) {
            this.last = null;
        }
        return n;
    }

    @Override
    public CharSequence next() {
        if (this.unparsed != null) {
            CharSequence result = this.unparsed;
            this.unparsed = null;
            this.last = result;
            return this.last;
        }
        this._lo = this._hi;
        if (this.next != null) {
            CharSequence result = this.next;
            this.next = null;
            this.last = result;
            return this.last;
        }
        this._lo = this._hi = this._pos;
        int term = 0;
        while (this.hasNext()) {
            char c = this.content.charAt(this._pos++);
            block0 : switch (term) {
                case 1: {
                    CharSequence token = this.token(c);
                    if (token != null) {
                        this.last = token;
                        return this.last;
                    }
                    ++this._hi;
                    break;
                }
                case 0: {
                    switch (c) {
                        case '\'': {
                            term = 39;
                            break block0;
                        }
                        case '\"': {
                            term = 34;
                            break block0;
                        }
                        case '`': {
                            term = 96;
                            break block0;
                        }
                    }
                    CharSequence token = this.token(c);
                    if (token != null) {
                        this.last = token;
                        return this.last;
                    }
                    ++this._hi;
                    term = 1;
                    break;
                }
                case 39: {
                    switch (c) {
                        case '\'': {
                            this._hi += 2;
                            this.last = this.flyweightSequence;
                            return this.last;
                        }
                    }
                    ++this._hi;
                    break;
                }
                case 34: {
                    switch (c) {
                        case '\"': {
                            this._hi += 2;
                            this.last = this.flyweightSequence;
                            return this.last;
                        }
                    }
                    ++this._hi;
                    break;
                }
                case 96: {
                    switch (c) {
                        case '`': {
                            this._hi += 2;
                            this.last = this.flyweightSequence;
                            return this.last;
                        }
                    }
                    ++this._hi;
                    break;
                }
            }
        }
        this.last = this.flyweightSequence;
        return this.last;
    }

    public CharSequence optionTok() {
        int blockCount = 0;
        boolean lineComment = false;
        while (this.hasNext()) {
            CharSequence cs = this.next();
            if (lineComment) {
                if (!Chars.equals(cs, '\n') && !Chars.equals(cs, '\r')) continue;
                lineComment = false;
                continue;
            }
            if (Chars.equals((CharSequence)"--", cs)) {
                lineComment = true;
                continue;
            }
            if (Chars.equals((CharSequence)"/*", cs)) {
                ++blockCount;
                continue;
            }
            if (Chars.equals((CharSequence)"*/", cs) && blockCount > 0) {
                --blockCount;
                continue;
            }
            if (blockCount != 0 || whitespace.contains(cs)) continue;
            return cs;
        }
        return null;
    }

    public int position() {
        return this._lo;
    }

    public void setContent(CharSequence cs, int lo, int hi) {
        this.content = cs;
        this.flyweightSequence = this.content instanceof ByteSequence ? this.floatingByteSequence : this.floatingSequence;
        this._pos = lo;
        this._len = hi;
        this.next = null;
        this.unparsed = null;
    }

    public void unparse() {
        this.unparsed = this.last;
    }

    private static CharSequence findToken0(char c, CharSequence content, int _pos, int _len, IntObjHashMap<List<CharSequence>> symbols) {
        List<CharSequence> l = symbols.get(c);
        if (l == null) {
            return null;
        }
        int sz = l.size();
        for (int i = 0; i < sz; ++i) {
            boolean match;
            CharSequence txt = l.get(i);
            int n = txt.length();
            boolean bl = match = n - 2 < _len - _pos;
            if (match) {
                for (int k = 1; k < n; ++k) {
                    if (content.charAt(_pos + (k - 1)) == txt.charAt(k)) continue;
                    match = false;
                    break;
                }
            }
            if (!match) continue;
            return txt;
        }
        return null;
    }

    private CharSequence token(char c) {
        CharSequence t = Lexer.findToken0(c, this.content, this._pos, this._len, this.symbols);
        if (t != null) {
            this._pos = this._pos + t.length() - 1;
            if (this._lo == this._hi) {
                return t;
            }
            this.next = t;
            return this.flyweightSequence;
        }
        return null;
    }

    static {
        whitespace.add(" ");
        whitespace.add("\t");
        whitespace.add("\n");
        whitespace.add("\r");
    }

    private class FloatingByteSequence
    extends FloatingSequence
    implements ByteSequence {
        private FloatingByteSequence() {
        }

        @Override
        public byte byteAt(int index) {
            return (byte)this.charAt(index);
        }

        @Override
        @NotNull
        public String toString() {
            return Chars.toUtf8String(this);
        }
    }

    private class FloatingSequence
    extends AbstractCharSequence {
        private FloatingSequence() {
        }

        @Override
        public int length() {
            return Lexer.this._hi - Lexer.this._lo;
        }

        @Override
        public char charAt(int index) {
            return Lexer.this.content.charAt(Lexer.this._lo + index);
        }
    }

    private static class LenComparator
    implements Comparator<CharSequence> {
        private LenComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            return o2.length() - o1.length();
        }
    }
}

