/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.LongList;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import java.util.Arrays;

public class LongHashSet
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final long noEntryValue = -1L;
    private final double loadFactor;
    private final LongList list;
    private long[] keys;
    private int free;
    private int capacity;
    private int mask;

    public LongHashSet() {
        this(8);
    }

    public LongHashSet(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private LongHashSet(int initialCapacity, double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.list = new LongList(initialCapacity);
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        this.loadFactor = loadFactor;
        this.keys = new long[capacity < 16 ? 16 : Numbers.ceilPow2(capacity)];
        this.mask = this.keys.length - 1;
        this.free = this.capacity = initialCapacity;
        this.clear();
    }

    public boolean add(long key) {
        boolean r = this.insertKey(key);
        if (r) {
            this.list.add(key);
            if (this.free == 0) {
                this.rehash();
            }
        }
        return r;
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, -1L);
        this.list.clear();
    }

    public boolean contains(long key) {
        int index = (int)(key & (long)this.mask);
        return Unsafe.arrayGet(this.keys, index) != -1L && (key == Unsafe.arrayGet(this.keys, index) || key == Unsafe.arrayGet(this.keys, index)) || this.probeContains(key, index);
    }

    public long get(int index) {
        return this.list.getQuick(index);
    }

    public void remove(long key) {
        if (this.list.remove(key)) {
            int index = (int)(key & (long)this.mask);
            if (key == Unsafe.arrayGet(this.keys, index)) {
                Unsafe.arrayPut(this.keys, index, -1L);
                ++this.free;
            } else {
                this.probeRemove(key, index);
            }
        }
    }

    public int size() {
        return this.capacity - this.free;
    }

    public String toString() {
        StringSink sink = new StringSink();
        this.toString(sink);
        return sink.toString();
    }

    private boolean insertKey(long key) {
        int index = (int)(key & (long)this.mask);
        if (Unsafe.arrayGet(this.keys, index) == -1L) {
            Unsafe.arrayPut(this.keys, index, key);
            --this.free;
            return true;
        }
        return Unsafe.arrayGet(this.keys, index) != key && this.probeInsert(key, index);
    }

    private boolean probeContains(long key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != -1L) continue;
            return false;
        } while (key != Unsafe.arrayGet(this.keys, index));
        return true;
    }

    private boolean probeInsert(long key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != -1L) continue;
            Unsafe.arrayPut(this.keys, index, key);
            --this.free;
            return true;
        } while (key != Unsafe.arrayGet(this.keys, index));
        return false;
    }

    private void probeRemove(long key, int index) {
        int i = index;
        do {
            if (key != Unsafe.arrayGet(this.keys, index = index + 1 & this.mask)) continue;
            Unsafe.arrayPut(this.keys, index, -1L);
            ++this.free;
            break;
        } while (i != index);
    }

    private void rehash() {
        int newCapacity = this.keys.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        long[] oldKeys = this.keys;
        this.keys = new long[newCapacity];
        Arrays.fill(this.keys, -1L);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldKeys, i) == -1L) continue;
            this.insertKey(Unsafe.arrayGet(oldKeys, i));
        }
    }

    private void toString(CharSink sink) {
        sink.put('[');
        boolean needComma = false;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == -1L) continue;
            if (needComma) {
                sink.put(',');
            }
            sink.put(this.keys[i]);
            if (needComma) continue;
            needComma = true;
        }
        sink.put(']');
    }
}

