/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.std.str.StringSink;
import java.util.Arrays;

public class LongList
implements Mutable {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private static final long DEFAULT_NO_ENTRY_VALUE = -1L;
    private static final int MAX_RUN_COUNT = 67;
    private static final int MAX_RUN_LENGTH = 33;
    private static final int QUICKSORT_THRESHOLD = 286;
    private static final int INSERTION_SORT_THRESHOLD = 47;
    private final long noEntryValue;
    private long[] buffer;
    private int pos = 0;

    public LongList() {
        this(16);
    }

    public LongList(int capacity) {
        this(capacity, -1L);
    }

    public LongList(int capacity, long noEntryValue) {
        this.buffer = new long[capacity];
        this.noEntryValue = noEntryValue;
    }

    public LongList(LongList other) {
        this.buffer = new long[other.size() < 16 ? 16 : other.size()];
        this.setPos(other.size());
        System.arraycopy(other.buffer, 0, this.buffer, 0, this.pos);
        this.noEntryValue = other.noEntryValue;
    }

    public void add(long value) {
        this.ensureCapacity(this.pos + 1);
        Unsafe.arrayPut(this.buffer, this.pos++, value);
    }

    public void add(LongList that) {
        int p = this.pos;
        int s = that.size();
        this.ensureCapacity(p + s);
        System.arraycopy(that.buffer, 0, this.buffer, p, s);
        this.pos += s;
    }

    public void add(int index, long element) {
        this.ensureCapacity(++this.pos);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.pos - index - 1);
        Unsafe.arrayPut(this.buffer, index, element);
    }

    public int binarySearch(long v) {
        int low = 0;
        int high = this.pos;
        while (low < high) {
            if (high - low < 65) {
                return this.scanSearch(v);
            }
            int mid = low + high - 1 >>> 1;
            long midVal = Unsafe.arrayGet(this.buffer, mid);
            if (midVal < v) {
                low = mid + 1;
                continue;
            }
            if (midVal > v) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative capacity. Integer overflow may be?");
        }
        int l = this.buffer.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            long[] buf = new long[newCap];
            System.arraycopy(this.buffer, 0, buf, 0, l);
            this.buffer = buf;
        }
    }

    public void erase() {
        this.pos = 0;
        Arrays.fill(this.buffer, this.noEntryValue);
    }

    public void extendAndSet(int index, long value) {
        this.ensureCapacity(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        Unsafe.arrayPut(this.buffer, index, value);
    }

    public void fill(int from, int to, long value) {
        Arrays.fill(this.buffer, from, to, value);
    }

    public long get(int index) {
        if (index < this.pos) {
            return Unsafe.arrayGet(this.buffer, index);
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public long getAndSetQuick(int index, long value) {
        long v = this.getQuick(index);
        Unsafe.arrayPut(this.buffer, index, value);
        return v;
    }

    public long getLast() {
        if (this.pos > 0) {
            return Unsafe.arrayGet(this.buffer, this.pos - 1);
        }
        return this.noEntryValue;
    }

    public long getQuick(int index) {
        return Unsafe.arrayGet(this.buffer, index);
    }

    public int hashCode() {
        long hashCode = 1L;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            long v = this.getQuick(i);
            hashCode = 31L * hashCode + (v == this.noEntryValue ? 0L : v);
        }
        return (int)hashCode;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof LongList && this.equals((LongList)that);
    }

    public String toString() {
        StringSink toStringBuilder = Misc.getThreadLocalBuilder();
        toStringBuilder.put('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                toStringBuilder.put(',');
            }
            toStringBuilder.put(this.get(i));
        }
        toStringBuilder.put(']');
        return ((Object)toStringBuilder).toString();
    }

    public void increment(int index) {
        Unsafe.arrayPut(this.buffer, index, Unsafe.arrayGet(this.buffer, index) + 1L);
    }

    public boolean remove(long v) {
        int index = this.indexOf(v);
        if (index > -1) {
            this.removeIndex(index);
            return true;
        }
        return false;
    }

    public void removeIndex(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, move);
        }
        Unsafe.arrayPut(this.buffer, --this.pos, this.noEntryValue);
    }

    public void seed(int capacity, long value) {
        this.ensureCapacity(capacity);
        this.pos = capacity;
        this.fill(0, capacity, value);
    }

    public void seed(int fromIndex, int count, long value) {
        int capacity = fromIndex + count;
        this.ensureCapacity(capacity);
        this.pos = capacity;
        Arrays.fill(this.buffer, fromIndex, capacity, value);
    }

    public void set(int index, long element) {
        if (index < this.pos) {
            Unsafe.arrayPut(this.buffer, index, element);
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public final void setPos(int pos) {
        this.ensureCapacity(pos);
        this.pos = pos;
    }

    public void setQuick(int index, long value) {
        Unsafe.arrayPut(this.buffer, index, value);
    }

    public void shuffle(Rnd rnd) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            this.swap(i, rnd.nextPositiveInt() & sz - 1);
        }
    }

    public int size() {
        return this.pos;
    }

    public void sort() {
        this.sort(0, this.size() - 1);
    }

    public LongList subset(int lo, int hi) {
        int _hi = hi > this.pos ? this.pos : hi;
        LongList that = new LongList(_hi - lo);
        System.arraycopy(this.buffer, lo, that.buffer, 0, _hi - lo);
        that.pos = _hi - lo;
        return that;
    }

    public void zero(int value) {
        Arrays.fill(this.buffer, 0, this.pos, (long)value);
    }

    private boolean equals(LongList that) {
        if (this.pos == that.pos) {
            int n = this.pos;
            for (int i = 0; i < n; ++i) {
                long lhs = this.getQuick(i);
                if (lhs == this.noEntryValue) {
                    return that.getQuick(i) == this.noEntryValue;
                }
                if (lhs != that.getQuick(i)) continue;
                return true;
            }
        }
        return false;
    }

    private int indexOf(long o) {
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (o != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    private void let(int a, int b) {
        Unsafe.arrayPut(this.buffer, a, Unsafe.arrayGet(this.buffer, b));
    }

    private int scanSearch(long v) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            long f = this.getQuick(i);
            if (f == v) {
                return i;
            }
            if (f <= v) continue;
            return -(i + 1);
        }
        return -(sz + 1);
    }

    private void sort(int left, int right) {
        LongList a;
        LongList b;
        if (right - left < 286) {
            this.sort(left, right, true);
            return;
        }
        int[] run = new int[68];
        int count = 0;
        run[0] = left;
        int k = left;
        while (k < right) {
            if (this.getQuick(k) < this.getQuick(k + 1)) {
                while (++k <= right && this.getQuick(k - 1) <= this.getQuick(k)) {
                }
            } else if (this.getQuick(k) > this.getQuick(k + 1)) {
                while (++k <= right && this.getQuick(k - 1) >= this.getQuick(k)) {
                }
                int lo = run[count] - 1;
                int hi = k;
                while (++lo < --hi) {
                    this.swap(lo, hi);
                }
            } else {
                int m = 33;
                while (++k <= right && this.getQuick(k - 1) == this.getQuick(k)) {
                    if (--m != 0) continue;
                    this.sort(left, right, true);
                    return;
                }
            }
            if (++count == 67) {
                this.sort(left, right, true);
                return;
            }
            run[count] = k;
        }
        if (run[count] == right++) {
            run[++count] = right;
        } else if (count == 1) {
            return;
        }
        byte odd = 0;
        int n = 1;
        while ((n <<= 1) < count) {
            odd = (byte)(odd ^ 1);
        }
        if (odd == 0) {
            b = this;
            a = new LongList(this.size());
            int i = left - 1;
            while (++i < right) {
                a.setQuick(i, b.getQuick(i));
            }
        } else {
            a = this;
            b = new LongList(this.size());
        }
        while (count > 1) {
            int last = 0;
            for (int k2 = 0 + 2; k2 <= count; k2 += 2) {
                int i;
                int hi = run[k2];
                int mi = run[k2 - 1];
                int p = i = run[k2 - 2];
                int q = mi;
                while (i < hi) {
                    if (q >= hi || p < mi && this.getQuick(p) <= this.getQuick(q)) {
                        b.setQuick(i, a.getQuick(p++));
                    } else {
                        b.setQuick(i, a.getQuick(q++));
                    }
                    ++i;
                }
                run[++last] = hi;
            }
            if ((count & 1) != 0) {
                int i = right;
                int lo = run[count - 1];
                while (--i >= lo) {
                    b.setQuick(i, a.getQuick(i));
                }
                run[++last] = right;
            }
            LongList t = a;
            a = b;
            b = t;
            count = last;
        }
    }

    private void sort(int left, int right, boolean leftmost) {
        long t;
        int length = right - left + 1;
        if (length < 47) {
            if (leftmost) {
                int i;
                int j = i = left;
                while (i < right) {
                    long ai = this.getQuick(i + 1);
                    while (ai < this.getQuick(j)) {
                        this.let(j + 1, j);
                        if (j-- != left) continue;
                    }
                    this.setQuick(j + 1, ai);
                    j = ++i;
                }
            } else {
                do {
                    if (left < right) continue;
                    return;
                } while (this.getQuick(++left) >= this.getQuick(left - 1));
                int k = left;
                while (++left <= right) {
                    long a2;
                    long a1 = this.getQuick(k);
                    if (a1 < (a2 = this.getQuick(left))) {
                        a2 = a1;
                        a1 = this.getQuick(left);
                    }
                    while (a1 < this.getQuick(--k)) {
                        this.let(k + 2, k);
                    }
                    this.setQuick(++k + 1, a1);
                    while (a2 < this.getQuick(--k)) {
                        this.let(k + 1, k);
                    }
                    this.setQuick(k + 1, a2);
                    k = ++left;
                }
                long last = this.getQuick(right);
                while (last < this.getQuick(--right)) {
                    this.let(right + 1, right);
                }
                this.setQuick(right + 1, last);
            }
            return;
        }
        int seventh = (length >> 3) + (length >> 6) + 1;
        int e3 = left + right >>> 1;
        int e2 = e3 - seventh;
        int e1 = e2 - seventh;
        int e4 = e3 + seventh;
        int e5 = e4 + seventh;
        if (this.getQuick(e2) < this.getQuick(e1)) {
            this.swap(e2, e1);
        }
        if (this.getQuick(e3) < this.getQuick(e2)) {
            t = this.getQuick(e3);
            this.let(e3, e2);
            this.setQuick(e2, t);
            if (t < this.getQuick(e1)) {
                this.let(e2, e1);
                this.setQuick(e1, t);
            }
        }
        if (this.getQuick(e4) < this.getQuick(e3)) {
            t = this.getQuick(e4);
            this.let(e4, e3);
            this.setQuick(e3, t);
            if (t < this.getQuick(e2)) {
                this.let(e3, e2);
                this.setQuick(e2, t);
                if (t < this.getQuick(e1)) {
                    this.let(e2, e1);
                    this.setQuick(e1, t);
                }
            }
        }
        if (this.getQuick(e5) < this.getQuick(e4)) {
            t = this.getQuick(e5);
            this.let(e5, e4);
            this.setQuick(e4, t);
            if (t < this.getQuick(e3)) {
                this.let(e4, e3);
                this.setQuick(e3, t);
                if (t < this.getQuick(e2)) {
                    this.let(e3, e2);
                    this.setQuick(e2, t);
                    if (t < this.getQuick(e1)) {
                        this.let(e2, e1);
                        this.setQuick(e1, t);
                    }
                }
            }
        }
        int less = left;
        int great = right;
        if (this.getQuick(e1) != this.getQuick(e2) && this.getQuick(e2) != this.getQuick(e3) && this.getQuick(e3) != this.getQuick(e4) && this.getQuick(e4) != this.getQuick(e5)) {
            long ak;
            long pivot1 = this.getQuick(e2);
            long pivot2 = this.getQuick(e4);
            this.let(e2, left);
            this.let(e4, right);
            while (this.getQuick(++less) < pivot1) {
            }
            while (this.getQuick(--great) > pivot2) {
            }
            int k = less - 1;
            block9: while (++k <= great) {
                ak = this.getQuick(k);
                if (ak < pivot1) {
                    this.let(k, less);
                    this.setQuick(less, ak);
                    ++less;
                    continue;
                }
                if (ak <= pivot2) continue;
                while (this.getQuick(great) > pivot2) {
                    if (great-- != k) continue;
                    break block9;
                }
                if (this.getQuick(great) < pivot1) {
                    this.let(k, less);
                    this.let(less, great);
                    ++less;
                } else {
                    this.let(k, great);
                }
                this.setQuick(great, ak);
                --great;
            }
            this.let(left, less - 1);
            this.setQuick(less - 1, pivot1);
            this.let(right, great + 1);
            this.setQuick(great + 1, pivot2);
            this.sort(left, less - 2, leftmost);
            this.sort(great + 2, right, false);
            if (less < e1 && e5 < great) {
                while (this.getQuick(less) == pivot1) {
                    ++less;
                }
                while (this.getQuick(great) == pivot2) {
                    --great;
                }
                k = less - 1;
                block13: while (++k <= great) {
                    ak = this.getQuick(k);
                    if (ak == pivot1) {
                        this.let(k, less);
                        this.setQuick(less, ak);
                        ++less;
                        continue;
                    }
                    if (ak != pivot2) continue;
                    while (this.getQuick(great) == pivot2) {
                        if (great-- != k) continue;
                        break block13;
                    }
                    if (this.getQuick(great) == pivot1) {
                        this.let(k, less);
                        this.setQuick(less, pivot1);
                        ++less;
                    } else {
                        this.let(k, great);
                    }
                    this.setQuick(great, ak);
                    --great;
                }
            }
            this.sort(less, great, false);
        } else {
            long pivot = this.getQuick(e3);
            for (int k = less; k <= great; ++k) {
                if (this.getQuick(k) == pivot) continue;
                long ak = this.getQuick(k);
                if (ak < pivot) {
                    this.let(k, less);
                    this.setQuick(less, ak);
                    ++less;
                    continue;
                }
                while (this.getQuick(great) > pivot) {
                    --great;
                }
                if (this.getQuick(great) < pivot) {
                    this.let(k, less);
                    this.let(less, great);
                    ++less;
                } else {
                    this.setQuick(k, pivot);
                }
                this.setQuick(great, ak);
                --great;
            }
            this.sort(left, less - 1, leftmost);
            this.sort(great + 1, right, false);
        }
    }

    private void swap(int a, int b) {
        long tmp = this.getQuick(a);
        this.setQuick(a, this.getQuick(b));
        this.setQuick(b, tmp);
    }
}

