/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.LongList;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import java.io.Closeable;

public class MemoryPages
implements Closeable,
Mutable {
    private final int pageSize;
    private final int mask;
    private final int bits;
    private final LongList pages = new LongList();
    private long cachePageHi;
    private long cachePageLo;

    public MemoryPages(int pageSize) {
        this.pageSize = Numbers.ceilPow2(pageSize);
        this.bits = Numbers.msb(this.pageSize);
        this.mask = this.pageSize - 1;
        this.allocate0(0L);
    }

    public long addressOf(long offset) {
        return this.pages.getQuick((int)(offset >>> this.bits)) + (offset & (long)this.mask);
    }

    public long allocate(long length) {
        return this.addressOf(this.allocateOffset(length));
    }

    public long allocateOffset(long length) {
        if (this.cachePageLo + length > this.cachePageHi) {
            this.allocate0(this.cachePageLo + length >>> this.bits);
        }
        return (this.cachePageLo += length) - length;
    }

    @Override
    public void clear() {
        this.cachePageLo = 0L;
        this.cachePageHi = this.cachePageLo + (long)this.pageSize;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.pages.size(); ++i) {
            long address = this.pages.getQuick(i);
            if (address == 0L) continue;
            Unsafe.free(address, this.pageSize);
        }
        this.pages.clear();
    }

    public int pageRemaining(long offset) {
        return this.pageSize - (int)(offset & (long)this.mask);
    }

    public int pageSize() {
        return this.pageSize;
    }

    public long size() {
        return this.cachePageLo;
    }

    private void allocate0(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        if (index >= (long)this.pages.size()) {
            this.pages.extendAndSet((int)index, Unsafe.malloc(this.pageSize));
        }
        this.cachePageLo = index << this.bits;
        this.cachePageHi = this.cachePageLo + (long)this.pageSize;
    }
}

