/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.common.NumericException;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Numbers;
import com.questdb.std.ObjectPool;
import com.questdb.std.ThreadLocal;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.FatalError;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.std.str.StringSink;
import java.io.Closeable;
import java.io.IOException;

public final class Misc {
    public static final String EOL = "\r\n";
    private static final ThreadLocal<StringSink> tlBuilder = new ThreadLocal<StringSink>(StringSink::new);

    private Misc() {
    }

    public static <T> T free(T object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                throw new FatalError(e);
            }
        }
        return null;
    }

    public static StringSink getThreadLocalBuilder() {
        StringSink b = (StringSink)tlBuilder.get();
        b.clear();
        return b;
    }

    public static int urlDecode(long lo, long hi, CharSequenceObjHashMap<CharSequence> map, ObjectPool<DirectByteCharSequence> pool) {
        long _lo = lo;
        long rp = lo;
        long wp = lo;
        DirectByteCharSequence temp = pool.next();
        int offset = 0;
        DirectByteCharSequence name = null;
        block8: while (rp < hi) {
            char b = (char)Unsafe.getUnsafe().getByte(rp++);
            switch (b) {
                case '=': {
                    if (_lo < wp) {
                        name = pool.next().of(_lo, wp);
                    }
                    _lo = rp - (long)offset;
                    break;
                }
                case '&': {
                    if (name != null) {
                        map.put(name, pool.next().of(_lo, wp));
                        name = null;
                    } else if (_lo < wp) {
                        map.put(pool.next().of(_lo, wp), "");
                    }
                    _lo = rp - (long)offset;
                    break;
                }
                case '+': {
                    Unsafe.getUnsafe().putByte(wp++, (byte)32);
                    continue block8;
                }
                case '%': {
                    try {
                        if (rp + 1L < hi) {
                            Unsafe.getUnsafe().putByte(wp++, (byte)Numbers.parseHexInt(temp.of(rp, rp += 2L)));
                            offset += 2;
                            continue block8;
                        }
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                    name = null;
                    break;
                }
            }
            Unsafe.getUnsafe().putByte(wp++, (byte)b);
        }
        if (_lo < wp) {
            if (name != null) {
                map.put(name, pool.next().of(_lo, wp));
            } else {
                map.put(pool.next().of(_lo, wp), "");
            }
        }
        return offset;
    }
}

