/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.common.NumericException;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.Numbers;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.NetworkError;
import com.questdb.std.str.CharSink;

public final class Net {
    public static final long MMSGHDR_SIZE;
    public static final long MMSGHDR_BUFFER_ADDRESS_OFFSET;
    public static final long MMSGHDR_BUFFER_LENGTH_OFFSET;
    public static final int EWOULDBLOCK;
    public static final int ERETRY = 0;
    public static final int EPEERDISCONNECT = -1;
    public static final int EOTHERDISCONNECT = -2;

    private Net() {
    }

    public static native long accept(long var0);

    public static void appendIP4(CharSink sink, long ip) {
        sink.put(ip & 0xFFL).put('.').put(ip >> 8 & 0xFFL).put('.').put(ip >> 16 & 0xFFL).put('.').put(ip >> 24 & 0xFFL);
    }

    public static native boolean bindTcp(long var0, int var2, int var3);

    public static boolean bindTcp(long fd, CharSequence address, int port) {
        return Net.bindTcp(fd, Net.parseIPv4(address), port);
    }

    public static boolean bindUdp(long fd, CharSequence address, int port) {
        return Net.bindUdp(fd, Net.parseIPv4(address), port);
    }

    public static native boolean bindUdp(long var0, int var2, int var3);

    public static int close(long fd) {
        return Files.close(fd);
    }

    public static native int configureNonBlocking(long var0);

    public static native void freeMsgHeaders(long var0);

    public static native void freeSockAddr(long var0);

    public static long getMMsgBuf(long msgPtr) {
        return Unsafe.getUnsafe().getLong(Unsafe.getUnsafe().getLong(msgPtr + MMSGHDR_BUFFER_ADDRESS_OFFSET));
    }

    public static int getMMsgBufLen(long msgPtr) {
        return Unsafe.getUnsafe().getInt(msgPtr + MMSGHDR_BUFFER_LENGTH_OFFSET);
    }

    public static native long getPeerIP(long var0);

    public static native int getPeerPort(long var0);

    public static native boolean isDead(long var0);

    public static boolean join(long fd, CharSequence bindIPv4Address, CharSequence groupIPv4Address) {
        return Net.join(fd, Net.parseIPv4(bindIPv4Address), Net.parseIPv4(groupIPv4Address));
    }

    public static native boolean join(long var0, int var2, int var3);

    public static native void listen(long var0, int var2);

    public static native long msgHeaders(int var0, int var1);

    public static native int recv(long var0, long var2, int var4);

    public static native int recvmmsg(long var0, long var2, int var4);

    public static native int send(long var0, long var2, int var4);

    public static native int sendTo(long var0, long var2, int var4, long var5);

    public static native int setRcvBuf(long var0, int var2);

    public static native int setSndBuf(long var0, int var2);

    public static long sockaddr(CharSequence address, int port) {
        return Net.sockaddr(Net.parseIPv4(address), port);
    }

    public static native long socketTcp(boolean var0);

    public static long socketUdp() {
        long fd = Net.socketUdp0();
        if (fd != -1L) {
            Files.OPEN_FILE_COUNT.incrementAndGet();
        }
        return fd;
    }

    private static native long socketUdp0();

    private static native long getMsgHeaderSize();

    private static native long getMsgHeaderBufferAddressOffset();

    private static native long getMsgHeaderBufferLengthOffset();

    private static native int getEwouldblock();

    private static native long sockaddr(int var0, int var1);

    private static int parseIPv4(CharSequence address) {
        int ip = 0;
        int count = 0;
        int lo = 0;
        try {
            int hi;
            while ((hi = Chars.indexOf(address, lo, '.')) > -1) {
                int n = Numbers.parseInt(address, lo, hi);
                ip = ip << 8 | n;
                ++count;
                lo = hi + 1;
            }
            if (count != 3) {
                throw new NetworkError("Invalid ip address: " + address);
            }
            return ip << 8 | Numbers.parseInt(address, lo, address.length());
        }
        catch (NumericException e) {
            throw new NetworkError("Invalid ip address: " + address);
        }
    }

    static {
        Os.init();
        EWOULDBLOCK = Net.getEwouldblock();
        if (Os.type == 2) {
            MMSGHDR_SIZE = Net.getMsgHeaderSize();
            MMSGHDR_BUFFER_ADDRESS_OFFSET = Net.getMsgHeaderBufferAddressOffset();
            MMSGHDR_BUFFER_LENGTH_OFFSET = Net.getMsgHeaderBufferLengthOffset();
        } else {
            MMSGHDR_SIZE = -1L;
            MMSGHDR_BUFFER_ADDRESS_OFFSET = -1L;
            MMSGHDR_BUFFER_LENGTH_OFFSET = -1L;
        }
    }
}

