/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.common.NumericException;
import com.questdb.std.Chars;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;

public final class Numbers {
    public static final int INT_NaN = Integer.MIN_VALUE;
    public static final long LONG_NaN = Long.MIN_VALUE;
    public static final double TOLERANCE = 1.0E-10;
    private static final long[] pow10;
    private static final long LONG_OVERFLOW_MAX = 0xCCCCCCCCCCCCCCCL;
    private static final long INT_OVERFLOW_MAX = 0xCCCCCCCL;
    private static final String NaN = "NaN";
    private static final String INFINITY = "Infinity";
    private static final double[] pow10d;
    private static final float[] pow10f;
    private static final char[] hexDigits;
    private static final int pow10max;

    private Numbers() {
    }

    public static void append(CharSink sink, double value, int scale) {
        double d = value;
        if (d == Double.POSITIVE_INFINITY) {
            sink.put(INFINITY);
            return;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            sink.put("-Infinity");
            return;
        }
        if (d != d) {
            sink.put(NaN);
            return;
        }
        if (value < 0.0) {
            sink.put('-');
            d = -value;
        }
        long factor = pow10[scale];
        long scaled = (long)(d * (double)factor + 0.5);
        int targetScale = scale + 1;
        while (targetScale < 20 && pow10[targetScale] <= scaled) {
            factor = pow10[targetScale++];
        }
        if (targetScale == 20) {
            sink.put(Double.toString(d));
            return;
        }
        while (targetScale > 0) {
            if (targetScale-- == scale) {
                sink.put('.');
            }
            sink.put((char)(48L + scaled / factor % 10L));
            factor /= 10L;
        }
    }

    public static void append(CharSink sink, float value, int scale) {
        int z;
        int targetScale;
        float f = value;
        if (f == Float.POSITIVE_INFINITY) {
            sink.put(INFINITY);
            return;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            sink.put("-Infinity");
            return;
        }
        if (f != f) {
            sink.put(NaN);
            return;
        }
        if (f < 0.0f) {
            sink.put('-');
            f = -f;
        }
        int factor = (int)pow10[scale];
        int scaled = (int)((double)(f * (float)factor) + 0.5);
        for (targetScale = scale + 1; targetScale < 11 && (z = factor * 10) <= scaled; ++targetScale) {
            factor = z;
        }
        if (targetScale == 11) {
            sink.put(Float.toString(f));
            return;
        }
        while (targetScale > 0) {
            if (targetScale-- == scale) {
                sink.put('.');
            }
            sink.put((char)(48 + scaled / factor % 10));
            factor /= 10;
        }
    }

    public static void append(CharSink sink, int value) {
        int i = value;
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                sink.put(NaN);
                return;
            }
            sink.put('-');
            i = -i;
        }
        if (i < 10) {
            sink.put((char)(48 + i));
        } else if (i < 100) {
            sink.put((char)(48 + i / 10));
            sink.put((char)(48 + i % 10));
        } else if (i < 1000) {
            sink.put((char)(48 + i / 100));
            int c = i % 100;
            sink.put((char)(48 + c / 10));
            sink.put((char)(48 + c % 10));
        } else if (i < 10000) {
            sink.put((char)(48 + i / 1000));
            int c = i % 1000;
            sink.put((char)(48 + c / 100));
            sink.put((char)(48 + (c %= 100) / 10));
            sink.put((char)(48 + c % 10));
        } else if (i < 100000) {
            sink.put((char)(48 + i / 10000));
            int c = i % 10000;
            sink.put((char)(48 + c / 1000));
            sink.put((char)(48 + (c %= 1000) / 100));
            sink.put((char)(48 + (c %= 100) / 10));
            sink.put((char)(48 + c % 10));
        } else if (i < 1000000) {
            sink.put((char)(48 + i / 100000));
            int c = i % 100000;
            sink.put((char)(48 + c / 10000));
            sink.put((char)(48 + (c %= 10000) / 1000));
            sink.put((char)(48 + (c %= 1000) / 100));
            sink.put((char)(48 + (c %= 100) / 10));
            sink.put((char)(48 + c % 10));
        } else if (i < 10000000) {
            sink.put((char)(48 + i / 1000000));
            int c = i % 1000000;
            sink.put((char)(48 + c / 100000));
            sink.put((char)(48 + (c %= 100000) / 10000));
            sink.put((char)(48 + (c %= 10000) / 1000));
            sink.put((char)(48 + (c %= 1000) / 100));
            sink.put((char)(48 + (c %= 100) / 10));
            sink.put((char)(48 + c % 10));
        } else if (i < 100000000) {
            sink.put((char)(48 + i / 10000000));
            int c = i % 10000000;
            sink.put((char)(48 + c / 1000000));
            sink.put((char)(48 + (c %= 1000000) / 100000));
            sink.put((char)(48 + (c %= 100000) / 10000));
            sink.put((char)(48 + (c %= 10000) / 1000));
            sink.put((char)(48 + (c %= 1000) / 100));
            sink.put((char)(48 + (c %= 100) / 10));
            sink.put((char)(48 + c % 10));
        } else if (i < 1000000000) {
            sink.put((char)(48 + i / 100000000));
            int c = i % 100000000;
            sink.put((char)(48 + c / 10000000));
            sink.put((char)(48 + (c %= 10000000) / 1000000));
            sink.put((char)(48 + (c %= 1000000) / 100000));
            sink.put((char)(48 + (c %= 100000) / 10000));
            sink.put((char)(48 + (c %= 10000) / 1000));
            sink.put((char)(48 + (c %= 1000) / 100));
            sink.put((char)(48 + (c %= 100) / 10));
            sink.put((char)(48 + c % 10));
        } else {
            sink.put((char)(48 + i / 1000000000));
            int c = i % 1000000000;
            sink.put((char)(48 + c / 100000000));
            sink.put((char)(48 + (c %= 100000000) / 10000000));
            sink.put((char)(48 + (c %= 10000000) / 1000000));
            sink.put((char)(48 + (c %= 1000000) / 100000));
            sink.put((char)(48 + (c %= 100000) / 10000));
            sink.put((char)(48 + (c %= 10000) / 1000));
            sink.put((char)(48 + (c %= 1000) / 100));
            sink.put((char)(48 + (c %= 100) / 10));
            sink.put((char)(48 + c % 10));
        }
    }

    public static void append(CharSink sink, long value) {
        long i = value;
        if (i > Integer.MAX_VALUE || i < Integer.MIN_VALUE) {
            if (i < 0L) {
                if (i == Long.MIN_VALUE) {
                    sink.put(NaN);
                    return;
                }
                sink.put('-');
                i = -i;
            }
            if (i < 10000000000L) {
                Numbers.appendLong10(sink, i);
            } else if (i < 100000000000L) {
                Numbers.appendLong11(sink, i);
            } else if (i < 1000000000000L) {
                Numbers.appendLong12(sink, i);
            } else if (i < 10000000000000L) {
                Numbers.appendLong13(sink, i);
            } else if (i < 100000000000000L) {
                Numbers.appendLong14(sink, i);
            } else if (i < 1000000000000000L) {
                Numbers.appendLong15(sink, i);
            } else if (i < 10000000000000000L) {
                Numbers.appendLong16(sink, i);
            } else if (i < 100000000000000000L) {
                Numbers.appendLong17(sink, i);
            } else if (i < 1000000000000000000L) {
                Numbers.appendLong18(sink, i);
            } else {
                Numbers.appendLong19(sink, i);
            }
        } else {
            Numbers.append(sink, (int)i);
        }
    }

    public static void appendHex(CharSink sink, int value) {
        int i = value;
        if (i < 0) {
            if (i == Integer.MIN_VALUE) {
                sink.put(NaN);
                return;
            }
            sink.put('-');
            i = -i;
        }
        if (i < 16) {
            sink.put(hexDigits[i]);
        } else if (i < 256) {
            sink.put(hexDigits[i / 16]);
            sink.put(hexDigits[i % 16]);
        } else if (i < 4096) {
            sink.put(hexDigits[i / 256]);
            int c = i % 256;
            sink.put(hexDigits[c / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 65536) {
            sink.put(hexDigits[i / 4096]);
            int c = i % 4096;
            sink.put(hexDigits[c / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x100000) {
            sink.put(hexDigits[i / 65536]);
            int c = i % 65536;
            sink.put(hexDigits[c / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x1000000) {
            sink.put(hexDigits[i / 0x100000]);
            int c = i % 0x100000;
            sink.put(hexDigits[c / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else if (i < 0x10000000) {
            sink.put(hexDigits[i / 0x1000000]);
            int c = i % 0x1000000;
            sink.put(hexDigits[c / 0x100000]);
            sink.put(hexDigits[(c %= 0x100000) / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        } else {
            sink.put(hexDigits[i / 0x10000000]);
            int c = i % 0x10000000;
            sink.put(hexDigits[c / 0x1000000]);
            sink.put(hexDigits[(c %= 0x1000000) / 0x100000]);
            sink.put(hexDigits[(c %= 0x100000) / 65536]);
            sink.put(hexDigits[(c %= 65536) / 4096]);
            sink.put(hexDigits[(c %= 4096) / 256]);
            sink.put(hexDigits[(c %= 256) / 16]);
            sink.put(hexDigits[c % 16]);
        }
    }

    public static void appendTrim(CharSink sink, double value, int inScale) {
        double d = value;
        int scale = inScale;
        if (d == Double.POSITIVE_INFINITY) {
            sink.put(INFINITY);
            return;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            sink.put("-Infinity");
            return;
        }
        if (d != d) {
            sink.put(NaN);
            return;
        }
        if (d == 0.0) {
            sink.put('0');
            return;
        }
        if (d < 0.0) {
            sink.put('-');
            d = -d;
        }
        long scaled = (long)(d * (double)pow10[scale] + 0.5);
        int k = 1;
        while (scaled % pow10[k] == 0L && (double)scaled / (double)pow10[k] > d) {
            ++k;
        }
        scale = scale - k + 1;
        long factor = pow10[scale];
        scaled = (long)(d * (double)factor + 0.5);
        int targetScale = scale + 1;
        while (targetScale < 20 && pow10[targetScale] <= scaled) {
            factor = pow10[targetScale++];
        }
        if (targetScale == 20) {
            sink.put(Double.toString(d));
            return;
        }
        while (targetScale > 0) {
            if (targetScale-- == scale) {
                sink.put('.');
            }
            sink.put((char)(48L + scaled / factor % 10L));
            factor /= 10L;
        }
    }

    public static int ceilPow2(int value) {
        int i = value;
        if (i != 0 && (i & i - 1) > 0) {
            i |= i >>> 1;
            i |= i >>> 2;
            i |= i >>> 4;
            i |= i >>> 8;
            i |= i >>> 16;
            if (++i < 0) {
                i >>>= 1;
            }
        }
        return i;
    }

    public static long ceilPow2(long value) {
        long i = value;
        if (i != 0L && (i & i - 1L) > 0L) {
            i |= i >>> 1;
            i |= i >>> 2;
            i |= i >>> 4;
            i |= i >>> 8;
            i |= i >>> 16;
            i |= i >>> 32;
            if (++i < 0L) {
                i >>>= 1;
            }
        }
        return i;
    }

    public static int compare(double a, double b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        long thisBits = Double.doubleToLongBits(1.0);
        long anotherBits = Double.doubleToLongBits(b);
        return Long.compare(anotherBits, thisBits);
    }

    public static int compare(float a, float b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        int thisBits = Float.floatToIntBits(a);
        int anotherBits = Float.floatToIntBits(b);
        return Integer.compare(anotherBits, thisBits);
    }

    public static int decodeInt(long val) {
        return val < 0L ? -((int)(-val & 0xFFFFFFFFL)) : (int)(val & 0xFFFFFFFFL);
    }

    public static int decodeLen(long val) {
        return (int)((val > 0L ? val : -val) >> 32);
    }

    public static long encodeIntAndLen(int value, int len) {
        if (value < 0) {
            return -((long)len << 32 | (long)(-value));
        }
        return (long)len << 32 | (long)value;
    }

    public static void main(String[] args) {
        System.out.println(Numbers.ceilPow2(242342348882389213L));
    }

    public static int msb(int value) {
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static int msb(long value) {
        return 63 - Long.numberOfLeadingZeros(value);
    }

    public static double parseDouble(CharSequence sequence) throws NumericException {
        int lim = sequence.length();
        if (lim == 0) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(0) == '-';
        int i = 0;
        if (negative) {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        switch (sequence.charAt(i)) {
            case 'N': {
                return Numbers.parseConst(sequence, i, lim, NaN, Double.NaN);
            }
            case 'I': {
                return Numbers.parseConst(sequence, i, lim, INFINITY, negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
            }
        }
        long val = 0L;
        int dp = -1;
        int dpe = lim;
        int exp = 0;
        block9: while (i < lim) {
            char c = sequence.charAt(i);
            switch (c) {
                case '.': {
                    dp = i;
                    break;
                }
                case 'E': 
                case 'e': {
                    exp = Numbers.parseInt(sequence, i + 1, lim);
                    if (dpe != lim) break block9;
                    dpe = i;
                    break block9;
                }
                case 'D': 
                case 'd': {
                    if (i + 1 < lim || i == 0) {
                        throw NumericException.INSTANCE;
                    }
                    if (dpe != lim) break block9;
                    dpe = i;
                    break block9;
                }
                default: {
                    if (c < '0' || c > '9') {
                        throw NumericException.INSTANCE;
                    }
                    if (val <= 0xCCCCCCCCCCCCCCCL) {
                        val = (val << 3) + (val << 1) + (long)(c - 48);
                        break;
                    }
                    if (dpe != lim) break;
                    dpe = i;
                }
            }
            ++i;
        }
        int n = exp = dp == -1 ? exp : exp - (dpe - dp - 1);
        if (exp > 308) {
            exp = 308;
        } else if (exp < -308) {
            exp = -308;
        }
        if (exp > 0) {
            return (double)(negative ? -val : val) * pow10d[exp];
        }
        return (double)(negative ? -val : val) / pow10d[-exp];
    }

    public static float parseFloat(CharSequence sequence) throws NumericException {
        boolean negative;
        int p;
        int lim = sequence.length();
        if (lim == (p = 0)) {
            throw NumericException.INSTANCE;
        }
        boolean bl = negative = sequence.charAt(p) == '-';
        if (negative) {
            ++p;
        }
        if (p >= lim) {
            throw NumericException.INSTANCE;
        }
        switch (sequence.charAt(p)) {
            case 'N': {
                return Numbers.parseFloatConst(sequence, p, lim, NaN, Float.NaN);
            }
            case 'I': {
                return Numbers.parseFloatConst(sequence, p, lim, INFINITY, negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
            }
        }
        int val = 0;
        int dp = -1;
        int dpe = lim;
        int exp = 0;
        block9: for (int i = p; i < lim; ++i) {
            char c = sequence.charAt(i);
            switch (c) {
                case '.': {
                    dp = i;
                    continue block9;
                }
                case 'E': 
                case 'e': {
                    exp = Numbers.parseInt(sequence, i + 1, lim);
                    if (dpe != lim) break block9;
                    dpe = i;
                    break block9;
                }
                case 'F': 
                case 'f': {
                    if (i == 0 || i + 1 < lim) {
                        throw NumericException.INSTANCE;
                    }
                    if (dpe != lim) break block9;
                    dpe = i;
                    break block9;
                }
                default: {
                    if (c < '0' || c > '9') {
                        throw NumericException.INSTANCE;
                    }
                    if ((long)val <= 0xCCCCCCCL) {
                        val = (val << 3) + (val << 1) + (c - 48);
                        continue block9;
                    }
                    if (dpe != lim) continue block9;
                    dpe = i;
                }
            }
        }
        int n = exp = dp == -1 ? exp : exp - (dpe - dp - 1);
        if (exp > 38) {
            exp = 38;
        } else if (exp < -38) {
            exp = -38;
        }
        if (exp > 0) {
            return (float)(negative ? -val : val) * pow10f[exp];
        }
        return (float)(negative ? -val : val) / pow10f[-exp];
    }

    public static int parseHexInt(CharSequence sequence) throws NumericException {
        int lim = sequence.length();
        if (lim == 0) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        for (int i = 0; i < lim; ++i) {
            int r;
            char c = sequence.charAt(i);
            int n = val << 4;
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    r = n + (c - 48);
                    break;
                }
                case 'A': 
                case 'a': {
                    r = n + 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    r = n + 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    r = n + 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    r = n + 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    r = n + 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    r = n + 15;
                    break;
                }
                default: {
                    throw NumericException.INSTANCE;
                }
            }
            if (r < val) {
                throw NumericException.INSTANCE;
            }
            val = r;
        }
        return val;
    }

    public static int parseInt(CharSequence sequence) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseInt0(sequence, 0, sequence.length());
    }

    public static int parseInt(CharSequence sequence, int p, int lim) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseInt0(sequence, p, lim);
    }

    public static int parseIntQuiet(CharSequence sequence) {
        try {
            if (sequence == null || Chars.equals((CharSequence)NaN, sequence)) {
                return Integer.MIN_VALUE;
            }
            return Numbers.parseInt0(sequence, 0, sequence.length());
        }
        catch (NumericException e) {
            return Integer.MIN_VALUE;
        }
    }

    public static long parseIntSafely(CharSequence sequence, int p, int lim) throws NumericException {
        char c;
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim || Numbers.notDigit(sequence.charAt(i))) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        while (i < lim && !Numbers.notDigit(c = sequence.charAt(i))) {
            int r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val == Integer.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        return Numbers.encodeIntAndLen(negative ? val : -val, i - p);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseIntSize(CharSequence sequence) throws NumericException {
        int lim = sequence.length();
        if (lim == 0) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(0) == '-';
        int i = 0;
        if (negative) {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        block4: while (i < lim) {
            char c = sequence.charAt(i);
            if (c < '0' || c > '9') {
                if (i != lim - 1) throw NumericException.INSTANCE;
                switch (c) {
                    case 'K': 
                    case 'k': {
                        val *= 1024;
                        break block4;
                    }
                    case 'M': 
                    case 'm': {
                        val = val * 1024 * 1024;
                        break block4;
                    }
                    default: {
                        throw NumericException.INSTANCE;
                    }
                }
            }
            int r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val != Integer.MIN_VALUE || negative) return negative ? val : -val;
        throw NumericException.INSTANCE;
    }

    public static long parseLong(CharSequence sequence) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseLong0(sequence, 0, sequence.length());
    }

    public static long parseLong(CharSequence sequence, int p, int lim) throws NumericException {
        if (sequence == null) {
            throw NumericException.INSTANCE;
        }
        return Numbers.parseLong0(sequence, p, lim);
    }

    public static long parseLongQuiet(CharSequence sequence) {
        if (sequence == null) {
            return Long.MIN_VALUE;
        }
        try {
            return Numbers.parseLong0(sequence, 0, sequence.length());
        }
        catch (NumericException e) {
            return Long.MIN_VALUE;
        }
    }

    public static double roundDown(double value, int scale) throws NumericException {
        if (scale < pow10max && scale > -1) {
            return Numbers.roundDown0(value, scale);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundHalfDown(double value, int scale) throws NumericException {
        if (scale + 2 < pow10max) {
            return value > 0.0 ? Numbers.roundHalfDown0(value, scale) : -Numbers.roundHalfDown0(-value, scale);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundHalfEven(double value, int scale) throws NumericException {
        if (scale + 2 < pow10max && scale > -1) {
            return value > 0.0 ? Numbers.roundHalfEven0(value, scale) : -Numbers.roundHalfEven0(-value, scale);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundHalfUp(double value, int scale) throws NumericException {
        if (scale + 2 < pow10max) {
            return value > 0.0 ? Numbers.roundHalfUp0(value, scale) : -Numbers.roundHalfUp0(-value, scale);
        }
        throw NumericException.INSTANCE;
    }

    public static double roundUp(double value, int scale) throws NumericException {
        if (scale < pow10max && scale > -1) {
            return Numbers.roundUp0(value, scale);
        }
        throw NumericException.INSTANCE;
    }

    private static boolean notDigit(char c) {
        return c < '0' || c > '9';
    }

    private static double roundHalfUp0(double value, int scale) {
        long val = (long)(value * (double)Unsafe.arrayGet(pow10, scale + 2) + 1.0E-10);
        return val % 100L < 50L ? Numbers.roundDown0(value, scale) : Numbers.roundUp0(value, scale);
    }

    private static double roundHalfEven0(double value, int scale) {
        long val = (long)(value * (double)Unsafe.arrayGet(pow10, scale + 2) + 1.0E-10);
        long remainder = val % 100L;
        if (remainder < 50L) {
            return Numbers.roundDown0(value, scale);
        }
        if (remainder == 50L && ((long)(value * (double)Unsafe.arrayGet(pow10, scale)) & 1L) == 0L) {
            return Numbers.roundDown0(value, scale);
        }
        return Numbers.roundUp0(value, scale);
    }

    private static double roundHalfDown0(double value, int scale) {
        long val = (long)(value * (double)Unsafe.arrayGet(pow10, scale + 2) + 1.0E-10);
        return val % 100L > 50L ? Numbers.roundUp0(value, scale) : Numbers.roundDown0(value, scale);
    }

    private static double roundDown0(double value, int scale) {
        return value < 0.0 ? -Numbers.roundDown00(-value, scale) : Numbers.roundDown00(value, scale);
    }

    private static double roundUp0(double value, int scale) {
        return value < 0.0 ? -Numbers.roundUp00(-value, scale) : Numbers.roundUp00(value, scale);
    }

    private static double roundUp00(double value, int scale) {
        long powten = Unsafe.arrayGet(pow10, scale);
        return (double)((long)(value * (double)powten + 1.0 - 1.0E-10)) / (double)powten;
    }

    private static double roundDown00(double value, int scale) {
        long powten = Unsafe.arrayGet(pow10, scale);
        return (double)((long)(value * (double)powten + 1.0E-10)) / (double)powten;
    }

    private static void appendLong10(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000000L));
        long c = i % 1000000000L;
        sink.put((char)(48L + c / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong11(CharSink sink, long i) {
        sink.put((char)(48L + i / 10000000000L));
        long c = i % 10000000000L;
        sink.put((char)(48L + c / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong12(CharSink sink, long i) {
        sink.put((char)(48L + i / 100000000000L));
        long c = i % 100000000000L;
        sink.put((char)(48L + c / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong19(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000000000000000L));
        long c = i % 1000000000000000000L;
        sink.put((char)(48L + c / 100000000000000000L));
        sink.put((char)(48L + (c %= 100000000000000000L) / 10000000000000000L));
        sink.put((char)(48L + (c %= 10000000000000000L) / 1000000000000000L));
        sink.put((char)(48L + (c %= 1000000000000000L) / 100000000000000L));
        sink.put((char)(48L + (c %= 100000000000000L) / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong18(CharSink sink, long i) {
        sink.put((char)(48L + i / 100000000000000000L));
        long c = i % 100000000000000000L;
        sink.put((char)(48L + c / 10000000000000000L));
        sink.put((char)(48L + (c %= 10000000000000000L) / 1000000000000000L));
        sink.put((char)(48L + (c %= 1000000000000000L) / 100000000000000L));
        sink.put((char)(48L + (c %= 100000000000000L) / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong17(CharSink sink, long i) {
        sink.put((char)(48L + i / 10000000000000000L));
        long c = i % 10000000000000000L;
        sink.put((char)(48L + c / 1000000000000000L));
        sink.put((char)(48L + (c %= 1000000000000000L) / 100000000000000L));
        sink.put((char)(48L + (c %= 100000000000000L) / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong16(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000000000000L));
        long c = i % 1000000000000000L;
        sink.put((char)(48L + c / 100000000000000L));
        sink.put((char)(48L + (c %= 100000000000000L) / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong15(CharSink sink, long i) {
        sink.put((char)(48L + i / 100000000000000L));
        long c = i % 100000000000000L;
        sink.put((char)(48L + c / 10000000000000L));
        sink.put((char)(48L + (c %= 10000000000000L) / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong14(CharSink sink, long i) {
        sink.put((char)(48L + i / 10000000000000L));
        long c = i % 10000000000000L;
        sink.put((char)(48L + c / 1000000000000L));
        sink.put((char)(48L + (c %= 1000000000000L) / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static void appendLong13(CharSink sink, long i) {
        sink.put((char)(48L + i / 1000000000000L));
        long c = i % 1000000000000L;
        sink.put((char)(48L + c / 100000000000L));
        sink.put((char)(48L + (c %= 100000000000L) / 10000000000L));
        sink.put((char)(48L + (c %= 10000000000L) / 1000000000L));
        sink.put((char)(48L + (c %= 1000000000L) / 100000000L));
        sink.put((char)(48L + (c %= 100000000L) / 10000000L));
        sink.put((char)(48L + (c %= 10000000L) / 1000000L));
        sink.put((char)(48L + (c %= 1000000L) / 100000L));
        sink.put((char)(48L + (c %= 100000L) / 10000L));
        sink.put((char)(48L + (c %= 10000L) / 1000L));
        sink.put((char)(48L + (c %= 1000L) / 100L));
        sink.put((char)(48L + (c %= 100L) / 10L));
        sink.put((char)(48L + c % 10L));
    }

    private static double parseConst(CharSequence sequence, int p, int lim, String target, double value) throws NumericException {
        Numbers.validateConst(sequence, p, lim, target);
        return value;
    }

    private static void validateConst(CharSequence sequence, int p, int lim, String target) throws NumericException {
        int len = target.length();
        if (lim - p != len) {
            throw NumericException.INSTANCE;
        }
        for (int i = 0; i < len; ++i) {
            if (sequence.charAt(p + i) == target.charAt(i)) continue;
            throw NumericException.INSTANCE;
        }
    }

    private static float parseFloatConst(CharSequence sequence, int p, int lim, String target, float value) throws NumericException {
        Numbers.validateConst(sequence, p, lim, target);
        return value;
    }

    private static int parseInt0(CharSequence sequence, int p, int lim) throws NumericException {
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        int val = 0;
        while (i < lim) {
            char c = sequence.charAt(i);
            if (c < '0' || c > '9') {
                throw NumericException.INSTANCE;
            }
            int r = (val << 3) + (val << 1) - (c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val == Integer.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        return negative ? val : -val;
    }

    private static long parseLong0(CharSequence sequence, int p, int lim) throws NumericException {
        if (lim == p) {
            throw NumericException.INSTANCE;
        }
        boolean negative = sequence.charAt(p) == '-';
        int i = p;
        if (negative) {
            ++i;
        }
        if (i >= lim) {
            throw NumericException.INSTANCE;
        }
        long val = 0L;
        while (i < lim) {
            char c = sequence.charAt(i);
            if (c == 'L' || c == 'l') {
                if (i != 0 && i + 1 >= lim) break;
                throw NumericException.INSTANCE;
            }
            if (c < '0' || c > '9') {
                throw NumericException.INSTANCE;
            }
            long r = (val << 3) + (val << 1) - (long)(c - 48);
            if (r > val) {
                throw NumericException.INSTANCE;
            }
            val = r;
            ++i;
        }
        if (val == Long.MIN_VALUE && !negative) {
            throw NumericException.INSTANCE;
        }
        return negative ? val : -val;
    }

    static {
        pow10d = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E128, 1.0E129, 1.0E130, 1.0E131, 1.0E132, 1.0E133, 1.0E134, 1.0E135, 1.0E136, 1.0E137, 1.0E138, 1.0E139, 1.0E140, 1.0E141, 1.0E142, 1.0E143, 1.0E144, 1.0E145, 1.0E146, 1.0E147, 1.0E148, 1.0E149, 1.0E150, 1.0E151, 1.0E152, 1.0E153, 1.0E154, 1.0E155, 1.0E156, 1.0E157, 1.0E158, 1.0E159, 1.0E160, 1.0E161, 1.0E162, 1.0E163, 1.0E164, 1.0E165, 1.0E166, 1.0E167, 1.0E168, 1.0E169, 1.0E170, 1.0E171, 1.0E172, 1.0E173, 1.0E174, 1.0E175, 1.0E176, 1.0E177, 1.0E178, 1.0E179, 1.0E180, 1.0E181, 1.0E182, 1.0E183, 1.0E184, 1.0E185, 1.0E186, 1.0E187, 1.0E188, 1.0E189, 1.0E190, 1.0E191, 1.0E192, 1.0E193, 1.0E194, 1.0E195, 1.0E196, 1.0E197, 1.0E198, 1.0E199, 1.0E200, 1.0E201, 1.0E202, 1.0E203, 1.0E204, 1.0E205, 1.0E206, 1.0E207, 1.0E208, 1.0E209, 1.0E210, 1.0E211, 1.0E212, 1.0E213, 1.0E214, 1.0E215, 1.0E216, 1.0E217, 1.0E218, 1.0E219, 1.0E220, 1.0E221, 1.0E222, 1.0E223, 1.0E224, 1.0E225, 1.0E226, 1.0E227, 1.0E228, 1.0E229, 1.0E230, 1.0E231, 1.0E232, 1.0E233, 1.0E234, 1.0E235, 1.0E236, 1.0E237, 1.0E238, 1.0E239, 1.0E240, 1.0E241, 1.0E242, 1.0E243, 1.0E244, 1.0E245, 1.0E246, 1.0E247, 1.0E248, 1.0E249, 1.0E250, 1.0E251, 1.0E252, 1.0E253, 1.0E254, 1.0E255, 1.0E256, 1.0E257, 1.0E258, 1.0E259, 1.0E260, 1.0E261, 1.0E262, 1.0E263, 1.0E264, 1.0E265, 1.0E266, 1.0E267, 1.0E268, 1.0E269, 1.0E270, 1.0E271, 1.0E272, 1.0E273, 1.0E274, 1.0E275, 1.0E276, 1.0E277, 1.0E278, 1.0E279, 1.0E280, 1.0E281, 1.0E282, 1.0E283, 1.0E284, 1.0E285, 1.0E286, 1.0E287, 1.0E288, 1.0E289, 1.0E290, 1.0E291, 1.0E292, 1.0E293, 1.0E294, 1.0E295, 1.0E296, 1.0E297, 1.0E298, 1.0E299, 1.0E300, 1.0E301, 1.0E302, 1.0E303, 1.0E304, 1.0E305, 1.0E306, 1.0E307, 1.0E308};
        pow10f = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f, 1.0E11f, 1.0E12f, 1.0E13f, 1.0E14f, 1.0E15f, 1.0E16f, 1.0E17f, 1.0E18f, 1.0E19f, 1.0E20f, 1.0E21f, 1.0E22f, 1.0E23f, 1.0E24f, 1.0E25f, 1.0E26f, 1.0E27f, 1.0E28f, 1.0E29f, 1.0E30f, 1.0E31f, 1.0E32f, 1.0E33f, 1.0E34f, 1.0E35f, 1.0E36f, 1.0E37f, 1.0E38f};
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        pow10 = new long[20];
        pow10max = 14;
        Numbers.pow10[0] = 1L;
        for (int i = 1; i < pow10.length; ++i) {
            Numbers.pow10[i] = pow10[i - 1] * 10L;
        }
    }
}

