/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.std;

import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ObjHashSet<T>
extends AbstractSet<T>
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final Object noEntryValue = new Object();
    private final double loadFactor;
    private final ObjList<T> list;
    private T[] keys;
    private int free;
    private int capacity;
    private int mask;

    public ObjHashSet() {
        this(16);
    }

    public ObjHashSet(int initialCapacity) {
        this(initialCapacity, 0.4f, 0.3f);
    }

    private ObjHashSet(int initialCapacity, double loadFactor, double hashFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        if (hashFactor <= 0.0 || hashFactor >= 1.0) {
            throw new IllegalArgumentException("0 < hashFactor < 1");
        }
        initialCapacity = (int)((double)initialCapacity * (1.0 + hashFactor));
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        this.loadFactor = loadFactor;
        this.keys = new Object[capacity < 16 ? 16 : Numbers.ceilPow2(capacity)];
        this.mask = this.keys.length - 1;
        this.free = this.capacity = initialCapacity;
        this.list = new ObjList(this.free);
        this.clear();
    }

    public void addAll(ObjHashSet<? extends T> that) {
        int n = that.size();
        for (int i = 0; i < n; ++i) {
            this.add(that.get(i));
        }
    }

    public T get(int index) {
        return this.list.getQuick(index);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.capacity - this.free;
    }

    @Override
    public boolean add(T key) {
        boolean r = this.insertKey(key);
        if (r) {
            this.list.add(key);
            if (this.free == 0) {
                this.rehash();
            }
        }
        return r;
    }

    @Override
    public boolean remove(Object key) {
        if (this.list.remove(key) > -1) {
            int index = this.idx(key);
            if (key.equals(Unsafe.arrayGet(this.keys, index))) {
                Unsafe.arrayPut(this.keys, index, noEntryValue);
                ++this.free;
                return true;
            }
            return this.probeRemove(key, index);
        }
        return false;
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, noEntryValue);
        this.list.clear();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    private int idx(T key) {
        return key == null ? 0 : key.hashCode() & this.mask;
    }

    private boolean insertKey(T key) {
        int index = this.idx(key);
        if (Unsafe.arrayGet(this.keys, index) == noEntryValue) {
            Unsafe.arrayPut(this.keys, index, key);
            --this.free;
            return true;
        }
        return key != Unsafe.arrayGet(this.keys, index) && !key.equals(Unsafe.arrayGet(this.keys, index)) && this.probeInsert(key, index);
    }

    private boolean probeInsert(T key, int index) {
        do {
            if (Unsafe.arrayGet(this.keys, index = index + 1 & this.mask) != noEntryValue) continue;
            Unsafe.arrayPut(this.keys, index, key);
            --this.free;
            return true;
        } while (key != Unsafe.arrayGet(this.keys, index) && !key.equals(Unsafe.arrayGet(this.keys, index)));
        return false;
    }

    private boolean probeRemove(Object key, int index) {
        int i = index;
        do {
            if (!key.equals(Unsafe.arrayGet(this.keys, index = index + 1 & this.mask))) continue;
            Unsafe.arrayPut(this.keys, index, noEntryValue);
            ++this.free;
            return true;
        } while (i != index);
        return false;
    }

    private void rehash() {
        int newCapacity = this.keys.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        T[] oldKeys = this.keys;
        this.keys = new Object[newCapacity];
        Arrays.fill(this.keys, noEntryValue);
        int i = oldKeys.length;
        while (i-- > 0) {
            if (Unsafe.arrayGet(oldKeys, i) == noEntryValue) continue;
            this.insertKey(Unsafe.arrayGet(oldKeys, i));
        }
    }
}

